#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
. ./arbitration_opertate_lib

# 初始化参数
function init() {
    local tmp_install_type=$1
    NTP_SERVER_IP=$2
    NTP_SERVER_IP_1=$3

    if [ "${tmp_install_type}" == 'full_install' ]; then
        INSTALL_TYPE="full_install"
    else
        INSTALL_TYPE="increment_install"
    fi
}

###################################################################
#
#
#     在前置检查中校验是否和上级ntp同步
#
#
###################################################################
function check_ntpservice_synchronize() {
    bash ./common_ntp.sh -cmd ntp_status_track
    if [ $? -ne 0 ]; then
        echo "[ERROR] The current node ntp service is in an unsynchronized state." >&2
        return 1
    fi
}

##################################
#
# 三方站点需检查NTP是否可连接
#
##################################
function check_third_ntp_connection() {
    if [ ! -z ${NTP_SERVER_IP} ]; then
        ntpdate -q ${NTP_SERVER_IP} >/dev/null 2>&1
        if [ $? -ne 0 ]; then
            echo "[ERROR] NTP server ${NTP_SERVER_IP} is not reachable" >&2
            return 1
        fi
    fi
    if [ ! -z ${NTP_SERVER_IP_1} ]; then
        ntpdate -q ${NTP_SERVER_IP_1} >/dev/null 2>&1
        if [ $? -ne 0 ]; then
            echo "[ERROR] NTP server ${NTP_SERVER_IP_1} is not reachable" >&2
            return 1
        fi
    fi
}

function main() {
    init $@
    if [ "${INSTALL_TYPE}" == "full_install" ]; then
        check_third_ntp_connection || return 1
    else
        check_ntpservice_synchronize || return 1
    fi
}

main $@
if [ $? -eq 0 ]; then
    create_check_result_file 100 "check_third_time_result.sh"
else
    create_check_result_file 255 "check_third_time_result.sh"
fi
