#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
. ./arbitration_opertate_lib

###################################################################
#
#
#     在前置检查中校验是否和上级ntp同步
#
#
###################################################################
function check_ntpservice_synchronize() {
    check_ntp_result="ERROR"
    bash ./common_ntp.sh -cmd ntp_status_track
    if [[ $? == 0 ]]; then
        check_ntp_result="OK"
    fi
    if [[ ${check_ntp_result} == "ERROR" ]]; then
        echo "[ERROR] The current node ntp service is in an unsynchronized state." >&2
    fi
}

function main() {
    check_ntpservice_synchronize
}

main $@
if [ $? -eq 0 ]; then
    create_check_result_file 100 "check_ntp_synchronize_result.sh"
else
    create_check_result_file 255 "check_ntp_synchronize_result.sh"
fi
