#!/bin/bash
#########################################################
# Copyright © Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# File name: pre_instasll_refresh_config.sh
# Description: 更新仲裁安装配置文件参数值
###########################################################

. ./arbitration_opertate_lib
# 仲裁安装参数配置文件
PROPERTIES_PATH="/opt/arbitration_file/arbitration_install_frame/config/arbitration_install.properties"
###################################################################
#     刷新配置文件
###################################################################
function refresh_properties() {
    local ret=0
    for param in $@;do
        key=$(echo ${param} | awk -F"=" '{print $1}')
        value=$(echo ${param} | awk -F"=" '{print $2}')
        sed -i "s#^\<${key}\>.*#${key} = ${value}#g" "${PROPERTIES_PATH}" 2>/dev/null || let ret=ret+1
    done
    if [ ${ret} -ne 0 ]; then
        echo "refresh arbitration_install.properties failed"
        return 1
    fi
    update_package
}

###################################################################
#     调测场景模板无包名，需要根据三方站点包名刷新
###################################################################
function update_package() {
    local pkg_aa_monitor_x86=$(cat ${PROPERTIES_PATH} | grep "pkg_aa_monitor_x86" | awk -F"=" '{print $2}')
    pkg_aa_monitor_x86=${pkg_aa_monitor_x86// /}
    if [ "${pkg_aa_monitor_x86}" == "" ]; then
        pkg_aa_monitor_x86=$(ls |grep "AAMonitor_linux-x86-64.zip" | head -n 1)
        sed -i "s#^\<pkg_aa_monitor_x86\>.*#pkg_aa_monitor_x86 = ${pkg_aa_monitor_x86}#g" "${PROPERTIES_PATH}" 2>/dev/null
    fi
    local pkg_aa_monitor_ARM=$(cat ${PROPERTIES_PATH} | grep "pkg_aa_monitor_ARM" | awk -F"=" '{print $2}')
    pkg_aa_monitor_ARM=${pkg_aa_monitor_ARM// /}
    if [ "${pkg_aa_monitor_ARM}" == "" ]; then
        pkg_aa_monitor_ARM=$(ls |grep "AAMonitor_linux-aarch64.zip" | head -n 1)
        sed -i "s#^\<pkg_aa_monitor_ARM\>.*#pkg_aa_monitor_ARM = ${pkg_aa_monitor_ARM}#g" "${PROPERTIES_PATH}" 2>/dev/null
    fi
}

function main() {
    refresh_properties "$@" || return 1
}

main "$@"
if [ $? -eq 0 ]; then
    create_check_result_file 100 "pre_install_refresh_config_result.sh"
else
    create_check_result_file 255 "pre_install_refresh_config_result.sh"
fi
