#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
IPV6_LENGTH=8

function get_real_full_ip() {
    ipv6_ip=$1
    echo "$ipv6_ip" | grep ":" >/dev/null 2>&1
    if [ $? -ne 0 ]; then
        echo "$ipv6_ip"
        return 0
    fi
    ipv6_length=$(echo ${ipv6_ip} | awk -F":" '{print NF}')
    real_ip=
    need_complete_count=$(expr ${IPV6_LENGTH} - ${ipv6_length})
    need_complete_count=$(expr ${need_complete_count} + 1)
    echo ${ipv6_ip} | grep '^:' >/dev/null && need_complete_count=$(expr ${need_complete_count} + 1)

    ipv6_ip=$(echo ${ipv6_ip} | sed 's/::/:|:/g')
    ip_arr=${ipv6_ip//:/ }

    for piece in ${ip_arr}; do
        if [ "${piece}" = "|" ]; then
            for id in $(seq 1 ${need_complete_count}); do
                if [ "${real_ip}" = "" ]; then
                    real_ip="0000"
                else
                    real_ip=$(echo "${real_ip}:0000")
                fi
            done
            continue
        fi
        piece_len=$(echo ${piece} | wc -L)
        need_piece_complete_count=$(expr 4 - ${piece_len})
        piece_copy="${piece}"
        for ix in $(seq 1 ${need_piece_complete_count}); do
            piece_copy=$(echo "0${piece_copy}")
        done
        if [ "${real_ip}" = "" ]; then
            real_ip="${piece_copy}"
        else
            real_ip=$(echo "${real_ip}:${piece_copy}")
        fi
    done

    echo ${real_ip} | tr '[a-z]' '[A-Z]'
}

function get_current_ips() {
    env_ips=
    for env_ip in $(ip addr | grep inet | awk '{print $2}' | awk -F'/' '{print $1}'); do
        real_env_ip=$(get_real_full_ip ${env_ip})
        env_ips=$(echo "${env_ips} ${real_env_ip}")
    done
    echo "${env_ips}"
}
