#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
. ./arbitration_opertate_lib

###########################################
#
#
#  卸载新版本
#
#
###########################################
function uninstall_arbitration() {
    arbitration_log INFO "UNINSTALL_ARBI" "Start uninstall new arbitration version."
    sh /opt/arbitration_file/uninstall_arbitration.sh
    arbitration_log INFO "UNINSTALL_ARBI" "Uninstall new arbitration version successfully."
}

###########################################
#
#
#  安装老版本
#
#
###########################################
function install_old_arbitration() {
    arbitration_log INFO "INSTALL_ARBI" "Start install old arbitration version."
    cd /opt/backup_arbitration/opt_arbitration/arbitration_file/
    rpm -ivh arbitration-common-*.rpm
    rpm -ivh arbitration-etcd-*.rpm --nodeps
    rpm -ivh arbitration-monitor-*.rpm
    arbitration_log INFO "INSTALL_ARBI" "Install old arbitration version successfully."
}

###########################################
#
#
#  还原备份文件
#
#
###########################################
function revert_file() {
    arbitration_log INFO "REVERT_FILE" "Start revert old files."
    cp -Rp /opt/backup_arbitration/opt_arbitration/arbitration /opt/
    cp -Rp /opt/backup_arbitration/opt_arbitration/arbitration_file /opt/
    cp -Rp /opt/backup_arbitration/opt_arbitration/arbitration-common /opt/
    cp -Rp /opt/backup_arbitration/opt_arbitration/arbitration-monitor /opt/
    cp -Rp /opt/backup_arbitration/opt_arbitration/arbitration-etcd /opt/

    cp -Rp /opt/backup_arbitration/var_log_arbitration/arbitration /var/log/
    cp -Rp /opt/backup_arbitration/var_log_arbitration/arbitration-common /var/log/
    cp -Rp /opt/backup_arbitration/var_log_arbitration/arbitration-etcd /var/log/
    cp -Rp /opt/backup_arbitration/var_log_arbitration/arbitration-monitor /var/log/
    cp -Rp /opt/backup_arbitration/var_log_arbitration/arbitration_install /var/log/
    cp -Rp /opt/backup_arbitration/var_log_arbitration/arbitration_watchdog /var/log/
    arbitration_log INFO "REVERT_FILE" "Revert old files successfully."
}
###########################################
#
#
#  重启仲裁服务
#
#
###########################################
function start_arbitration() {
    arbitration_log INFO "START_ARBI" "Start arbitration."
    cd /opt/arbitration_file/
    sh start_arbitration.sh
    arbitration_log INFO "START_ARBI" "Start arbitration successfully."
    arbitration_log INFO "START_ARBI" "Start watchdog."
    sh start_aamonitor_watchdog.sh
    arbitration_log INFO "START_ARBI" "Start watchdog successfully."
}

function main() {
    arbitration_log INFO "ROLLBACK" "Start rollback."
    uninstall_arbitration
    install_old_arbitration
    revert_file
    start_arbitration
    arbitration_log INFO "ROLLBACK" "Rollback successfully."
}

main
