#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
. ./arbitration_opertate_lib
. ./env.properties
master_location="$1"
slave_location="$2"
master_node_ips="$3"
slave_node_ips="$4"

if [[ ${master_location} == "" ]] && [[ ${slave_location} == "" ]] && [[ ${master_node_ips} == "" ]] && [[ ${slave_node_ips} == "" ]]; then
    master_location=$(cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties | grep master_location_name | awk -F = '{printf $2}')
    slave_location=$(cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties | grep slave_location_name | awk -F = '{printf $2}')
    master_node_ips=$(cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties | grep master_nodes_inner_ips | awk -F = '{printf $2}')
    slave_node_ips=$(cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties | grep slave_nodes_inner_ips | awk -F = '{printf $2}')
fi

master_nodes_ip_port=$(echo "${master_node_ips}:${MONITOR_PORT}" | sed "s/,/:${MONITOR_PORT},/g")
slave_nodes_ip_port=$(echo "${slave_node_ips}:${MONITOR_PORT}" | sed "s/,/:${MONITOR_PORT},/g")

#记录结果
function create_check_file() {
    result_code=$1
    create_check_result_file ${result_code} "check_arbitration_service.sh"
}

###################################################
#
#   设置优选站点
#
###################################################
function set_primary_location() {
    arbitration_log INFO "SET_PRIMARY_LOCATION" "Start set primary location, master_location_name:${master_location} slave_location:${slave_location}."

    #配置优先站点时，key值为站点名称字符串较小的在前
    if [[ "${master_location}" < "${slave_location}" ]]; then
        open_conf="${master_location}_${slave_location}"
    else
        open_conf="${slave_location}_${master_location}"
    fi

    sudo -u arbiter bash ${MONITOR_HOME}/script/etcd-client.sh --set /monitor/conf/open_${open_conf} ${master_location}
    if [[ $? != "0" ]]; then
        arbitration_log ERROR "SET_PRIMARY_LOCATION" "Set primary location failed."
        $(create_check_file 255)
        exit 1
    fi

    sudo -u arbiter bash ${MONITOR_HOME}/script/etcd-client.sh --set /monitor/status/split_open_dcserial ${master_location}
    if [[ $? != "0" ]]; then
        arbitration_log ERROR "SET_PRIMARY_LOCATION" "Set primary location failed."
        $(create_check_file 255)
        exit 1
    fi

    sudo -u arbiter bash ${MONITOR_HOME}/script/etcd-client.sh --set /monitor/conf/open_ips_${open_conf} ${master_nodes_ip_port}
    if [[ $? != "0" ]]; then
        arbitration_log ERROR "SET_PRIMARY_LOCATION" "Set primary location failed."
        $(create_check_file 255)
        exit 1
    fi
    sudo -u arbiter bash ${MONITOR_HOME}/script/etcd-client.sh --set /monitor/conf/close_ips_${open_conf} ${slave_nodes_ip_port}
    if [[ $? != "0" ]]; then
        arbitration_log ERROR "SET_PRIMARY_LOCATION" "Set primary location failed."
        $(create_check_file 255)
        exit 1
    fi

    arbitration_log INFO "SET_PRIMARY_LOCATION" "Set primary location successfully."
}
###################################################
#
#   检查仲裁节点是否安装成功
#
###################################################
function check_arbitration_service_status() {
    retry_time=30
    check_arbitration_service_result="ERROR"

    while (($retry_time > 0)); do
        sudo -u arbiter bash ${MONITOR_HOME}/script/etcd-client.sh --get /monitor/status/$master_location/detail_status
        master_status=$?
        sudo -u arbiter bash ${MONITOR_HOME}/script/etcd-client.sh --get /monitor/status/$slave_location/detail_status
        slave_status=$?
        if [[ $master_status == "0" && $slave_status == "0" ]]; then
            check_arbitration_service_result="OK"
            break
        fi
        arbitration_log INFO "SET_PRIMARY_LOCATION" "Waitting 10s for arbitration service to be ok."
        ((retry_time--))
        sleep 10
    done
    if [[ ${check_arbitration_service_result} == "OK" ]]; then
        arbitration_log INFO "SET_PRIMARY_LOCATION" "Set primary location successfully."
        $(create_check_file 100)
    else
        arbitration_log ERROR "SET_PRIMARY_LOCATION" "Set primary location failed, master_status:${master_status}, slave_status:${slave_status}."
        $(create_check_file 255)
        exit 1
    fi
}

function main() {
    rm -f /opt/arbitration_file/check_arbitration_service.sh
    set_primary_location
    check_arbitration_service_status
}

main
