#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
. ./arbitration_opertate_lib
. ./env.properties
ARBITRATION_WATCHDOG_LOG_FILE_PATH="${ARBITTRATION_WATCHDOG_LOG}/arbitration_watchdog.log"
ARBITRATION_CONFIG_PATH="${ARBITRATION_HOME}/conf/arbitration_conf.properties"

master_nodes_inner_ips=$1
slave_nodes_inner_ips=$2
third_node_inner_ip=$3
master_location_name=$4
slave_location_name=$5
aam_pkg=$6
ntp_server_ip=$7

########################################################
#
#
#       准备目录
#
#
########################################################
function init() {
    mkdir -p ${ARBITTRATION_WATCHDOG_LOG}
    chmod -Rf 500 ${ARBITTRATION_WATCHDOG_LOG}
    mkdir -p ${ARBITRATION_HOME}/script
    mkdir -p ${ARBITRATION_HOME}/conf
    mkdir -p ${ARBITRATION_HOME}/env
    cp /opt/arbitration_file/env.properties ${ARBITRATION_HOME}/env
}

########################################################
#
#
#       记录仲裁配置
#
#
########################################################
function record_arbitration_conf() {
    arbitration_log INFO "RECORD_ARBITRATION_CONFIG" "Start record arbitration configuration."
    echo "master_nodes_inner_ips=${master_nodes_inner_ips}" >${ARBITRATION_CONFIG_PATH}
    echo "slave_nodes_inner_ips=${slave_nodes_inner_ips}" >>${ARBITRATION_CONFIG_PATH}
    echo "third_node_inner_ip=${third_node_inner_ip}" >>${ARBITRATION_CONFIG_PATH}
    echo "ntp_server_ip=${ntp_server_ip}" >>${ARBITRATION_CONFIG_PATH}
    echo "master_location_name=${master_location_name}" >>${ARBITRATION_CONFIG_PATH}
    echo "slave_location_name=${slave_location_name}" >>${ARBITRATION_CONFIG_PATH}
    echo "MONITOR_PORT=${MONITOR_PORT}" >>${ARBITRATION_CONFIG_PATH}
    chmod -f 500 ${ARBITRATION_CONFIG_PATH}
}

########################################################
#
#
#       修改文件出现
#
#
########################################################
function modify_dir_chmod_chown() {
    arbitration_log INFO "MODIFY_DIR_CHMOD_CHOWN" "Start modify."
    chown -Rf arbiter:ArbiterGroup ${ETCD_HOME}
    chown -Rf arbiter:ArbiterGroup ${MONITOR_HOME}
    chown -Rf arbiter:ArbiterGroup ${COMMON_HOME}
    find ${COMMON_HOME} -name "*.sh" | xargs -r chmod 500
}

########################################################
#
#
#       获取ntp type
#
#
########################################################
function get_ntp_type() {
    bash /opt/arbitration_file/common_ntp.sh -cmd get_ntp_type >/dev/null 2>&1
}

########################################################
#
#
#       标记版本
#
#
########################################################
function mark_version() {
    flag_path="${ARBITRATION_HOME}/conf/version.flag"
    aam_version=$(echo $aam_pkg | awk -F"_" '{print $2}')
    echo $aam_version >$flag_path
}

########################################################
#
#
#       仲裁软件守护进程
#
#
########################################################
function start_arbitration_watchdog() {
    arbitration_log INFO "START_AAMONITOR_WATCHDOT" "Start watchdog."
    cp /opt/arbitration_file/aamonitor_watchdog.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/query_arbitration.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/uninstall_arbitration.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/public.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/common_ntp.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/ntpd_util.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/chronyd_util.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/ntpType ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/check_etcd_health.sh ${ARBITRATION_HOME}/script
    cp -rf /opt/arbitration_file/healthcheck ${ARBITRATION_HOME}/script
    cp -rf /opt/arbitration_file/arbiter_commissioning.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/check_sopuser_valid.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/config_third_ntp.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/modify_third_node_pwd.sh ${ARBITRATION_HOME}/script
    mark_version
    aamonitor_watchdog_path_format=$(echo "${ARBITRATION_HOME}/script/aamonitor_watchdog.sh" | sed 's/\//\\\//g')

    get_os_version >/dev/null
    os_version=$?
    if [[ ${os_version} -eq 3 || ${os_version} -eq 11 || ${os_version} -eq 12 || ${os_version} -eq 20 ]]; then
        sed -i "/${aamonitor_watchdog_path_format}/d" /etc/crontab
        echo "*/1 * * * * root /bin/sh ${ARBITRATION_HOME}/script/aamonitor_watchdog.sh >/dev/null 2>&1" >>/etc/crontab
        service cron restart &>/dev/null || service crond restart &>/dev/null
    else
        if [[ -e /var/spool/cron/root ]]; then
            sed -i "/${aamonitor_watchdog_path_format}/d" /var/spool/cron/root
            echo "*/1 * * * * /bin/sh ${ARBITRATION_HOME}/script/aamonitor_watchdog.sh >/dev/null 2>&1" >>/var/spool/cron/root
        else
            arbitration_log INFO "CONFIG_AAMONITOR_WATCHDOT" "Create root watchdog."
            echo "*/1 * * * * /bin/sh ${ARBITRATION_HOME}/script/aamonitor_watchdog.sh >/dev/null 2>&1" >/var/spool/cron/root
            chmod 600 /var/spool/cron/root
        fi
    fi
}

###########################################################################################
#
#
#       老版本由于使用cron，导致/var/spool/clientmqueue爆满而升级仲裁节点操作系统失败
#       避免在/var/spool/clientmqueue下生成文件，修改相关配置文件
#       只有三方站点需要此操作
#
#
###########################################################################################
function fn_stop_crond_mail() {
    arbitration_log INFO "UPGRADE_POST_OPERATION" "the node id third: ${is_third}"
    local aam_properties="${MONITOR_HOME}/conf/aam.properties"
    local is_third=$(cat ${aam_properties} | grep "aam.local.role" | awk -F'=' '{print $2}')
    arbitration_log INFO "UPGRADE_POST_OPERATION" "the node id third: ${is_third}"
    [ "${is_third}" != "third" ] && return 0

    [ -e /etc/euleros-release ] && [ "$(grep -i euler /etc/euleros-release)" ] || return 0
    [ -e /etc/kylin-release ] && [ "$(grep -i Kylin /etc/kylin-release)" ] || return 0
    if [ ! -f /etc/crontab -o ! -f /etc/sysconfig/crond ]; then
        arbitration_log ERROR "UPGRADE_POST_OPERATION" "File /etc/crontab or /etc/sysconfig/crond is not found."
        return 0
    fi
    grep -q "^\s*MAILTO=['\"]*root['\"]*\s*$" /etc/crontab || {
        arbitration_log ERROR "UPGRADE_POST_OPERATION" "The MAILTO value does not meet the requirements."
        return 0
    }
    grep -q "^\s*CRONDARGS=.*-m off" /etc/sysconfig/crond && {
        arbitration_log INFO "UPGRADE_POST_OPERATION" "is already set. "
        return 0
    }
    local args_centont=$(egrep "^\s*CRONDARGS=" /etc/sysconfig/crond | sed -e 's/^\s*CRONDARGS=//' -re 's/^\s*"|"\s*$//g' -e "s/^\s*'|'\s*$//g")

    if [ -z "${args_centont}" ]; then
        sed -ri '/^\s*CRONDARGS=/c\CRONDARGS="-m off"' /etc/sysconfig/crond
    else
        sed -ri "/^\s*CRONDARGS=/c\CRONDARGS=\"-m off ${args_centont}\"" /etc/sysconfig/crond
    fi

    sed -ri '/^\s*MAILTO=root/c\MAILTO=""' /etc/crontab
    [ -f /etc/crontab ] && sed -i '/check_IO_status.sh/d' /etc/crontab
    systemctl restart crond
    return 0
}

function upgrade_post_operation() {
    local upgrade_flag=/opt/backupArb/arbitration_upgrade.flag
    [ ! -f ${upgrade_flag} ] && return 0
    # 升级场景，删除运行升级flag文件
    local upgrade_running_flag=/opt/backupArb/arbitration_upgrade_running.flag
    if [ -f ${upgrade_running_flag} ]; then
        arbitration_log INFO "UPGRADE_POST_OPERATION" "delete upgrade running flag"
        rm -rf ${upgrade_running_flag}
    fi

    arbitration_log INFO "UPGRADE_POST_OPERATION" "upgrade post operation"
    # 设置crond相关配置，避免inode达到100%
    fn_stop_crond_mail
    rm -rf ${upgrade_flag}
    arbitration_log INFO "UPGRADE_POST_OPERATION" "upgrade post operation success"
}

function post_operation() {
    arbitration_log INFO "POST_OPERATION" "start to post operation"
    [ -d ${ARBITRATION_TEMP_PATH} ] && rm -rf ${ARBITRATION_TEMP_PATH}

    # 仲裁目录被破坏场景，删除标志文件
    [ -f /opt/backupArb/arbitration_error.flag ] && rm -f /opt/backupArb/arbitration_error.flag

    local jre_pkg=$(echo /opt/arbitration_file/EnvJRE*.zip)
    [ -f ${jre_pkg} ] && rm -f ${jre_pkg}

    local python_pkg=$(echo /opt/arbitration_file/EnvPython*.zip)
    [ -f ${python_pkg} ] && rm -f ${python_pkg}

    # x86+ARM场景 清理多余上传的AAMonitor包
    rm -f /opt/arbitration_file/*AAMonitor_linux-*.zip

    # 删除欧方安装目录
    rm -rf /opt/install

    arbitration_log INFO "POST_OPERATION" "success to post operation"
}

########################################################
#
# 移动配置路由脚本到/usr/local/ostools/bond_tools目录下
#
########################################################
function cp_config_routes_sh() {
    ostool_dir="/usr/local/ostools/bond_tools"
    # 修补旧版本问题，删除/usr/local/ostools/bond_tools文件
    [ -f "${ostool_dir}" ] && rm -f "${ostool_dir}"
    mkdir -p "${ostool_dir}"
    cp /opt/arbitration_file/config_routes.sh ${ostool_dir}
    chmod 500 ${ostool_dir}/config_routes.sh >/dev/null 2>&1
}

function modify_chmod() {
    local modify_arr=("/opt/arbitration_file" "${ARBITRATION_HOME}")
    for item in ${modify_arr[*]}; do
        find "${item}" -type d | xargs chmod 750 &>/dev/null
        find "${item}" -type f | xargs chmod 640 &>/dev/null
        find "${item}" -type f -name "*.sh" | xargs chmod 500 &>/dev/null
        find "${item}" -type f -name "*.pyc" | xargs chmod 400 &>/dev/null
    done
}

function main() {
    init || return 1
    record_arbitration_conf || return 1
    modify_dir_chmod_chown || return 1
    start_arbitration_watchdog || return 1
    upgrade_post_operation || return 1
    post_operation || return 1
    cp_config_routes_sh || return 1
    modify_chmod || return 1
}

main
if [ $? -eq 0 ]; then
    create_check_result_file 100 "check_start_aamonitor_watchdog_result.sh"
else
    create_check_result_file 255 "check_start_aamonitor_watchdog_result.sh"
fi
