#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.
. ./arbitration_opertate_lib
. ./env.properties

#记录结果
function create_check_file() {
    result_code=$1
    create_check_result_file ${result_code} "check_stop_arbitration_result.sh"
}

function clean_crontab() {
    aamonitor_watchdog_path_format=$(echo "${ARBITRATION_HOME}/script/aamonitor_watchdog.sh" | sed 's/\//\\\//g')
    arbitration_log INFO "STOP_ARBITRATION" "Clean crontab."
    if [[ -e /etc/SuSE-release ]]; then
        sed -i "/${aamonitor_watchdog_path_format}/d" /etc/crontab
        service cron restart >/dev/null
    elif [[ -e /etc/euleros-release ]] || [[ -e /etc/kylin-release ]]; then
        sed -i "/${aamonitor_watchdog_path_format}/d" /etc/crontab
        systemctl restart crond.service >/dev/null
    else
        sed -i "/${aamonitor_watchdog_path_format}/d" /var/spool/cron/root
    fi
}

function stop_etcd_monitor() {
    #启动前停止服务
    ps -ef | grep ${MONITOR_HOME} | grep -v grep | awk '{print $2}' | xargs -r kill -9

    if [[ $? == "0" ]]; then
        arbitration_log INFO "STOP_MONITOR" "Stop monitor successfully."
        $(create_check_file 100)
    else
        arbitration_log INFO "STOP_MONITOR" "Stop monitor failed."
        $(create_check_file 255)
        exit
    fi

    ps -ef | grep ${ETCD_HOME} | grep -v grep | awk '{print $2}' | xargs -r kill -9
    if [[ $? == "0" ]]; then
        arbitration_log INFO "STOP_ETCD" "Stop etcd successfully."
        $(create_check_file 100)
    else
        arbitration_log INFO "STOP_ETCD" "Stop etcd failed."
        $(create_check_file 255)
        exit
    fi

}

function main() {
    clean_crontab
    stop_etcd_monitor
}

main
