#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd.2019-2022. All rights reserved.

INDEX=$1
function get_work_path() {
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}" | awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]; then
        dir=$(echo "${dir}" | sed 's/^.//')
        cur_path="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]; then
        cur_path="$(pwd)/${dir}"
    else
        cur_path="${dir}"
    fi
    return 0
}
get_work_path

function usage() {
    echo "Usage: bash uninstall_arbitration.sh \${INDEX}"
    echo "The detail arbitration index are as follows."
    echo ""
    bash ${cur_path}/query_arbitration.sh
}

function init_index() {
    if [ "${INDEX}" = "" ]; then
        usage
        return 1
    fi
    echo ${INDEX} | grep -q '[^0-9]' >/dev/null 2>&1
    if [ $? -eq 0 ]; then
        usage
        return 1
    fi

    if [ "${INDEX}" = "0" ]; then
        FORMAT_INDEX=""
    else
        FORMAT_INDEX=$(echo "_${INDEX}")
    fi
    if [ ! -d "/opt/arbitration-etcd${FORMAT_INDEX}" ]; then
        echo "Invalid index: ${INDEX}"
        usage
        return 1
    fi
    bash ${cur_path}/query_arbitration.sh -index ${INDEX}
    while true; do
        echo "Make sure you are ready to uninstall. [Y/N]"
        read select
        if [ "${select}" = "n" -o "${select}" = "N" ]; then
            return 1
        elif [ "${select}" = "y" -o "${select}" = "Y" ]; then
            return 0
        else
            continue
        fi
    done
}

function uninstall_all() {
    clean_crontab
    uninstall
    delete_user_and_group
}

function clean_crontab() {
    echo "Clean crontab task."
    ARBITRATION_HOME="/opt/arbitration${FORMAT_INDEX}"
    aamonitor_watchdog_path_format=$(echo "${ARBITRATION_HOME}/script/aamonitor_watchdog.sh" | sed 's/\//\\\//g')
    if [[ -e /etc/SuSE-release ]]; then
        sed -i "/${aamonitor_watchdog_path_format}/d" /etc/crontab
        service cron restart >/dev/null
    elif [[ -e /etc/euleros-release ]] || [[ -e /etc/kylin-release ]]; then
        sed -i "/${aamonitor_watchdog_path_format}/d" /etc/crontab
        systemctl restart crond.service >/dev/null
    else
        sed -i "/${aamonitor_watchdog_path_format}/d" /var/spool/cron/root
    fi
}

function delete_user_and_group() {
    echo "Delete arbitration user."
    # 如果仲裁目录还有，则不删除用户，防止影响其他仲裁软件运行
    ls /opt | grep arbitration-etcd >/dev/null 2>&1
    if [ $? -eq 0 ]; then
        echo "Skip delete arbitration user."
        return 0
    fi
    userdel -rf arbiter >/dev/null 2>&1
    grep ArbiterGroup /etc/group >/dev/null
    if [[ $? == "0" ]]; then
        groupdel ArbiterGroup
    fi
}

#卸载前处理
function pre_uninstall() {
    init_index || return 1
}

function uninstall() {
    echo "Stop arbitration process."
    ps -ef | grep -w "Dprocess.name=arbitration-monitor${FORMAT_INDEX}" | grep -v grep | awk '{print $2}' | xargs -r kill -9 >/dev/null 2>&1
    if [ "${INDEX}" = "0" ]; then
        ps -ef | grep -Ew "Dprocess.name=arbitration-monitor|Dprocess.name=arbitration-monitor_${INDEX}" | grep -v grep | awk '{print $2}' | xargs -r kill -9 >/dev/null 2>&1
    fi
    ps -ef | grep -w arbitration-etcd${FORMAT_INDEX} | grep -v grep | awk '{print $2}' | xargs -r kill -9 >/dev/null 2>&1
    if [ "${INDEX}" = "0" ]; then
        ps -ef | grep -w arbitration-etcd | grep -v grep | awk '{print $2}' | xargs -r kill -9 >/dev/null 2>&1
    fi
    # 当index为0时，如果rpm中查到仲裁软件包，则执行卸载，兼容老版本场景
    if [ ${INDEX} -eq 0 ]; then
        rpm -qa | grep arbitration | xargs -r rpm -e 2>/dev/null
    fi
    rm -rf /opt/arbitration-etcd${FORMAT_INDEX}
    rm -rf /opt/arbitration-monitor${FORMAT_INDEX}
    rm -rf /opt/arbitration-common${FORMAT_INDEX}
    rm -rf /opt/arbitration${FORMAT_INDEX}
    rm -rf /var/log/arbitration/${INDEX}
    rm -rf /var/log/arbitration-monitor/${INDEX}
    rm -rf /var/log/arbitration-etcd/${INDEX}
    # 兼容老版本场景，删除日志时删除老版本的日志
    if [ "${INDEX}" = "0" ]; then
        rm -rf /var/log/arbitration/etcd
        rm -rf /var/log/arbitration/monitor
        rm -rf /var/log/arbitration-monitor/arbitration-monitor*
        rm -rf /var/log/arbitration-etcd/etcd.log
        rm -rf /var/log/arbitration-etcd/logs/etcd-server.log*
    fi
}

function main() {
    pre_uninstall || return 1
    echo "Start uninstall arbitration."
    uninstall_all || return 1
}

main
exit $?
