#!/bin/bash

#########################################################
# Copyright © Huawei Technologies Co., Ltd. 2019-2022. All rights reserved.
# File name: prepare_source_code.sh
# Description: zip source code
###########################################################
. ./arbitration_opertate_lib
. ./public.sh

PKG_NAME_x86=""
PKG_NAME_ARM=""
ARBITRATION_PKG=""
CPU_TYPE=""

function init_param() {
    local master_and_slave_inner_card_ips=$1
    CPU_TYPE=$2
    local package_name=$3
    local other_package_name=$4
    if [ "${CPU_TYPE}" == "x86+ARM" -a "${other_package_name}" != "" ]; then
        PKG_NAME_x86="${package_name}"
        PKG_NAME_ARM="${other_package_name}"
    else
        ARBITRATION_PKG="${package_name}"
    fi
    
    AB_INNER_IPS=($(echo ${master_and_slave_inner_card_ips} | tr ',' ' '))
    local node_size=${#AB_INNER_IPS[@]}
    get_root_params
}

function get_os_type() {
    local node_ip=$1
    local node_pwd=$2
    local expect_output=$(expect << ENF 2>&1
set timeout 5
spawn ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null ${node_ip}
expect {
    "*yes/no*" {send "yes\r";exp_continue}
    "*assword:" {send -- "${node_pwd}\r"}
}

expect {
    "*#" { send "arch\r"}
}
expect {
    "*aarch*" { send_user "RESULT=aarch64\r"; exit; }
    "*x86*" { send_user "RESULT=x86_64\r"; exit; }
}
expect timeout {
    exit 1
}
ENF
)

    echo "${expect_output}" | grep -q "RESULT=x86_64"
    if [ $? -eq 0 ]; then
        echo "x86_64"
    fi
    echo "${expect_output}" | grep -q "RESULT=aarch64"
    if [ $? -eq 0 ]; then
        echo "aarch64"
    fi
}

function scp_file_retry() {
    local node_ip=$1
    local node_pwd=$2
    local ret_file="/opt/arbitration_file/${node_ip}_scp_pkg.result"
    if [ -f "${ret_file}" ]; then
        rm -f "${ret_file}"
    fi
    if [ "${ARBITRATION_PKG}" == "" -o "${CPU_TYPE}" == "x86+ARM" ]; then
        ARBITRATION_PKG=$(get_arbitration_pkg "${node_ip}" "${node_pwd}")
    fi
    arbitration_log "WARN" "scp local flag file to ${node_ip}"
    local ret=1
    for i in {1..3}; do
        scp_file "${node_ip}" "${node_pwd}" "/opt/arbitration_file/${ARBITRATION_PKG}" "/opt/arbitration_file/${ARBITRATION_PKG}"
        if [ $? -eq 0 ]; then
            echo "success" > "${ret_file}"
            arbitration_log "INFO" "success to scp local flag file to ${node_ip}"
            return 0
        fi
        arbitration_log "WARN" "retry to scp local flag file to ${node_ip}"
        sleep 1
    done
    echo "failed" > "${ret_file}"
    arbitration_log "ERROR" "failed to scp local flag file to ${node_ip}"
    return 1
}

function get_arbitration_pkg() {
    local node_ip=$1
    local node_pwd=$2
    local os_type=$(get_os_type "${node_ip}" "${node_pwd}")
    if [ "${os_type}" == "" ]; then
        arbitration_log "ERROR" "failed to get os_type from ${node_ip}"
        return 1
    fi
    if [ "${os_type}" == "x86_64" ]; then
        echo "${PKG_NAME_x86}"
    else
        echo "${PKG_NAME_ARM}"
    fi 
}

function scp_file() {
    local node_ip=$1
    local node_pwd=$2
    local local_file=$3
    local remote_file=$4
    [ -f /root/.ssh/known_hosts ] && sed -i "/^${node_ip} /d" /root/.ssh/known_hosts
    node_ip="\["${node_ip}"\]"
    expect <<EOF >/dev/null 2>&1
    set timeout 900
    spawn scp -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null ${local_file} root@${node_ip}:${remote_file}
        expect {
            "*yes/no*" {send "yes\r";exp_continue}
            "*assword:" {send -- "${node_pwd}\r"}
        }
        expect "100%" { sleep 2;exit 0 }
        expect timeout { exit 1 }
    expect eof
EOF
    return $?
}


function get_root_params() {
    read -p "es_input: node_1_root_pwd" -s -r node_1_root_pwd
    node_1_root_pwd=$(get_format_pwd ${node_1_root_pwd})
    read -p "es_input: node_2_root_pwd" -s -r node_2_root_pwd
    node_2_root_pwd=$(get_format_pwd ${node_2_root_pwd})
    read -p "es_input: node_3_root_pwd" -s -r node_3_root_pwd
    node_3_root_pwd=$(get_format_pwd ${node_3_root_pwd})
    read -p "es_input: node_4_root_pwd" -s -r node_4_root_pwd
    node_4_root_pwd=$(get_format_pwd ${node_4_root_pwd})
    node_root_pwd_list=(${node_1_root_pwd} ${node_3_root_pwd})

    if [ ${node_size} -eq 4 ]; then
        node_root_pwd_list=(${node_1_root_pwd} ${node_2_root_pwd} ${node_3_root_pwd} ${node_4_root_pwd})
    fi
}

function get_format_pwd() {
    local pwd=$1
    echo ${pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g'
}

function upload_package() {
    for ((i=0; i<${#AB_INNER_IPS[@]}; i++));do
        local node_ip=${AB_INNER_IPS[i]}
        scp_file_retry ${node_ip} ${node_root_pwd_list[i]} &
    done
}

function check_result() {
    # 等待30分钟传包
    retry_time=360
    local ip_inner_list=()
    local ret=0
    while (($retry_time > 0)); do
        for ((i=0; i<${#AB_INNER_IPS[@]}; i++));do
            local node_ip=${AB_INNER_IPS[i]}
            echo ${ip_inner_list[@]} | grep -wq ${node_ip}
            if [ $? -ne 0 -a -e "/opt/arbitration_file/${node_ip}_scp_pkg.result" ]; then
                sleep 1
                ip_inner_list=(${ip_inner_list[@]} ${node_ip})
                local upload_msg=$(cat /opt/arbitration_file/${node_ip}_scp_pkg.result)
                arbitration_log INFO "UPLOAD" "upload package to ${node_ip} ${upload_msg}."
                echo "upload package to ${node_ip} ${upload_msg}."
                echo ${upload_msg} | grep -q "failed" && ret=1
            fi
        done
        if [ ${#ip_inner_list[@]} -eq ${#AB_INNER_IPS[@]} ]; then
            break
        fi
        ((retry_time--))
        arbitration_log DEBUG "UPLOAD" "Waitting 5s for upload package."
        echo "Waitting 5s for upload package.."
        sleep 5
    done
    if [ ${#ip_inner_list[@]} -ne ${#AB_INNER_IPS[@]} -o ${ret} -ne 0 ]; then
        arbitration_log ERROR "UPLOAD" "upload package failed."
        echo "upload package failed."
        return 1
    fi
}

function main()
{
    init_param "$@"
    upload_package || return 1
    check_result || return 1
}

main "$@"
if [ $? -eq 0 ]; then
    create_check_result_file 100 "upload_arbitration_package_result.sh"
else
    create_check_result_file 255 "upload_arbitration_package_result.sh"
fi
exit $?