#!/bin/bash
. ./controller.sh
################################################################################
# Function    : check_hostname
# Description : check the hostname not repeat.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_hostname()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0

    cd /root/EasySuite/888/script/
    res_hostname=$(/root/EasySuite/888/script/python/bin/python launch.pyc processor -i -exec pre.install.check_items -check_item "install.check_hostname")
    if [[ $? == 0 ]]
    then
        echo " "
        echo "-----------------------------------------------------"
        echo "[successfully]The hostname check success, please continue."
        echo "-----------------------------------------------------"
        echo " "
    else
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]The hostname can not repeat, please confirm it."
        IFS=$'@'
        if  [ ! "${res_hostname}" ]; then
            echo "[ERROR message]: Execution exception."
            echo "[Solution]: Please go to the /var/log/insight/install/ directory to view logs."
            echo "-----------------------------------------------------"
            echo " "
        else
            echo ${res_hostname}
            echo "-----------------------------------------------------"
            echo " "
        fi
        echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
        #failed
    else
        return 0
    fi
}
