#!/bin/bash
. ./controller.sh
################################################################################
# Function    : check_iops
# Description : check the iops is right.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_iops()
{
    iops_min=1500
    typeset -i error_fail_num=0
    # 判断是否安装了fio
    rpm -qa | grep fio > /dev/null
    if [ $? -ne 0 ]
    then
        # fio未安装直接返回0
        return 0
    else
        # 若已安装判断iops是否满足要求，满足返回0，不满足返回1
        res_disk_iops=$(fio --randrepeat=1 --ioengine=libaio --direct=1 --gtod_reduce=1 --name=test --filename=/opt/rand_Write_Test --bs=4k --iodepth=64 --size=1024M --readwrite=randwrite -runtime=10 | grep iops= | awk -F, '{print $3}' | awk -F= '{print $2}')
        # iops查询命令执行失败或者iops值小于1500既休眠1s后重试一次
        if [ $? -ne 0  -o ${res_disk_iops} -le ${iops_min} ]
        then
            rm -rf /opt/rand_Write_Test
            sleep 1
            res_disk_iops=$(fio --randrepeat=1 --ioengine=libaio --direct=1 --gtod_reduce=1 --name=test --filename=/opt/rand_Write_Test --bs=4k --iodepth=64 --size=1024M --readwrite=randwrite -runtime=8 | grep iops= | awk -F, '{print $3}' | awk -F= '{print $2}')
            if [ $? -ne 0  -o ${res_disk_iops} -le ${iops_min} ]
            then
                rm -rf /opt/rand_Write_Test
                echo " "
                echo "-----------------------------------------------------"
                echo "[failed]The IOPS of the disk is less than ${iops_min}, which does not meet installation specifications."
                echo "iops="${res_disk_iops}
                echo "-----------------------------------------------------"
                echo "[Solution]:Replace a disk with a large IOPS."
                echo " "
                echo " " >&2
                ((error_fail_num=error_fail_num+1))
            else
                echo " "
                echo "-----------------------------------------------------"
                echo "[successfully]Disk IOPS meets the installation specifications, please continue."
                echo "-----------------------------------------------------"
                echo " "
            fi
        else
            echo " "
            echo "-----------------------------------------------------"
            echo "[successfully]Disk IOPS meets the installation specifications, please continue."
            echo "-----------------------------------------------------"
            echo " "
        fi
        rm -rf /opt/rand_Write_Test
        if [ ${error_fail_num} -gt 0 ]
        then
            return 1
        else
            return 0
        fi
    fi
}