#!/bin/bash
CUR_PATH=$(cd `dirname $0`;pwd)
cd ${CUR_PATH}
. ./controller.sh
################################################################################
# Function    :
# Description : check whether mellanox driver exists.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
log_file='/opt/install_check/install_mellanox.log'
function check_mellanox_driver()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0

    cd /root/EasySuite/888/script/
    check_mellanox_driver_res=$(/root/EasySuite/888/script/python/bin/python launch.pyc processor -i -exec pre.install.check_items -check_item "install.check_mellanox")
    if [[ $? == 0 ]]
    then
        echo " "
        echo "-----------------------------------------------------"
        echo "[successfully]The ethernet driver meets installation specifications, please continue."
        echo "-----------------------------------------------------"
        echo " "
    else
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]"
        echo "[failed]The ethernet driver does not meets installation specifications, please confirm it."
        IFS=$'@'
        echo "run error ${check_mellanox_driver_res}"
        echo "-----------------------------------------------------"
        echo " "
        echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
        #failed
    else
        return 0
    fi
}
function main()
{
    #the variable count the fail time of check step
    typeset -i fail_num=0
    echo "custom_check_mellanox_driver"
    check_mellanox_driver
    if [ $? -ne 0 ]
    then
        ((fail_num=fail_num+1))
        echo "[failed] Install mellanox driver failed !"
        echo "[failed] please to check whether you upload the driver package."
        echo "custom_check_mellanox_driver"
    else
        echo "[successfully] Install mellanox driver successfully !"
        echo "custom_check_mellanox_driver"
    fi

    if [ ${fail_num} -gt 0 ]
    then
        echo "===========================CHECKING ENVIRONMENT FAILED=============================="
        echo "===================================================================================="
        rm -rf /opt/install_check
        return 1
    fi
}
IFS=$'\n'
echo "es_input: os_root_user_pwd"
read -sr os_root_user_pwd
main "$@"
