#!/bin/bash
. ./controller.sh
################################################################################
# Function    : check_cpu_arch
# Description : check the cpu arch is right.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_os_version()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0

    cd /root/EasySuite/888/script/
    res_os_version=$(/root/EasySuite/888/script/python/bin/python launch.pyc processor -i -exec pre.install.check_items -check_item "install.check_os_version")
    if [[ $? == 0 ]]
    then
        echo " "
        echo "-----------------------------------------------------"
        echo "[successfully]OS version meets the installation specifications, please continue."
        echo "-----------------------------------------------------"
        echo " "
    else
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]OS version not meets the installation specifications, please confirm it."
        IFS=$'@'
        echo ${res_os_version}
        echo "-----------------------------------------------------"
        echo " "
        echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
        #failed
    else
        return 0
    fi
}
