#!/bin/bash
. ./controller.sh
################################################################################
# Function    : check_network_config
# Description : check network configuration is right.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_network_config()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0

    cd /root/EasySuite/888/script/
    res_e_initparm=$(/root/EasySuite/888/script/python/bin/python launch.pyc processor -i -exec pre.scale.init_param <<eof
${os_root_user_pwd}
eof
)

    if [[ $? == 0 ]]
    then
        echo " "
        echo "custom_check_network_configuration"
        echo "-----------------------------------------------------"
        echo "[successfully]The network configuration is successful, Please continue."
        echo "-----------------------------------------------------"
        echo " "
    else
        echo "custom_check_network_configuration"
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]Failed to configure the network, Please confirm it."
        IFS="@"
        if  [ ! "${res_e_initparm#'es_input: os_pwd_root'}" ]; then
            echo "[ERROR message]: Execution exception."
            echo "[Solution]: Please go to the /var/log/insight/install/ directory to view logs."
            echo "-----------------------------------------------------"
            echo " "
        else
            echo ${res_e_initparm#'es_input: os_pwd_root'}
            echo "-----------------------------------------------------"
            echo " "
        fi
		echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
		#failed
    else
        return 0
    fi
}