const envLang = getLocale() === 'zh' ? 'zh-cn' : 'en-us';
const errorCode = document.getElementById('pcsContainer').getAttribute('error_code') || '503';
const i18nObj = {
  'en-us': {
    404: 'Sorry, but the page you requested could not be found.',
    403: 'You are not authorized to perform this operation, contact the administrator.',
    413: 'Request entity too large.',
    500: 'The server cannot perform this request, contact the administrator.',
    502: 'The current session has been obtained by another terminal, causing security risks. Please log in again.',
    503: 'Service Unavailable, contact the administrator.',
    504: 'Gateway timeout.',
    back: 'Return to Homepage',
  },
  'zh-cn': {
    404: '对不起，您请求的页面不存在',
    403: '您无权执行此操作，请联系管理员',
    413: '请求的实体太大',
    500: '服务器无法执行此请求，请联系管理员',
    502: '当前会话已被其他终端获取进行操作，存在安全风险，请重新登录',
    503: '服务异常，请联系管理员',
    504: '网关超时',
    back: '返回首页',
  },
};

function enterPressListener() {
  if (event.keyCode === 13) {
    goMainPage();
  }
  
}

function getLocale() {
  const localeMap = {
    'locale=zh-cn': 'zh',
    'locale=en-us': 'en',
  }
  const cookie = document.cookie.split(';');
  const cookieLocale = cookie.filter(value => {
    return value.indexOf('locale=') > -1;
  });
  return localStorage.locale || localeMap[cookieLocale[0]] || window.navigator?.language?.substring(0, 2) || 'en';
}

function goMainPage() {
  if (window.top !== window.self) {
    window.top.location = '/';
  } else {
    window.location = '/';
  }
}

var template =
'<div class="pcs-top"></div>' +
'<div class="pcs-middle pcs-error-' + errorCode + '"></div>' +
'<div class="pcs-bottom">' +
'<label class="psc-describe">' + i18nObj[envLang][errorCode] + '</label>' +
'<a class="pcs-back" tabindex="0">' +
i18nObj[envLang]?.back +
'</a>' +
'</div>';

document.querySelector('#pcsContainer').innerHTML = template;

let reback = document.querySelector('.pcs-back')
reback.onclick = goMainPage
reback.onkeypress = enterPressListener