#!/bin/bash
. ./controller.sh
################################################################################
# Function    : check_cpu_num
# Description : check the cpu_num.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_cpu_num()
{
    #idle CPU
    total_cpu=$(cat /proc/cpuinfo | grep "processor" | sort -u | wc -l)
 
    if [ -z "${cpu_num}" ];then
        print_log "WARNING" "CPU num to be checked is not configured, skip check CPU num."
        return 0
    fi
    print_log "INFO" "Expected CPU num is ${cpu_num}."
    if [  ${total_cpu} -lt ${cpu_num} ]; then
        print_log "ERROR" "The logic CPU number is ${total_cpu}, less than ${cpu_num}."
        return 1
    fi
    print_log "INFO" "CPU check successfully. The logic CPU number is ${total_cpu}, Expected CPU number is ${cpu_num}."
    return 0
}
 
################################################################################
# Function    : check_cpu_type
# Description : check the cpu_type.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_cpu_type()
{
    # cpu_type 为空跳过检查
    if [ -z "${cpu_type}" ];then


        print_log "WARNING" "CPU type to be checked is not configured, skip check CPU type."
        return 0
    fi
    print_log "INFO" "Expected CPU type is ${cpu_type}."
    local cpu_arch=$(arch)
    if [[ "${cpu_type}" = "X86"  &&  "${cpu_arch}" = "x86_64" ]] || [[ "${cpu_type}" = "ARM"  &&  "${cpu_arch}" = "aarch64" ]]; then
        print_log "INFO" "CPU check successfully. The logic CPU type is ${cpu_arch}, Expected CPU type is ${cpu_type}."
        return 0
    fi
    print_log "ERROR" "CPU type check failure. The logic CPU type is ${cpu_arch}, Expected CPU number is ${cpu_type}."
    return 1
}
 
function custom_check_cpu(){
    check_cpu_num
    local check_cpu_num_result=$?
    check_cpu_type
    local check_cpu_type_result=$?
    if [ ${check_cpu_num_result} -eq 0 ] && [ ${check_cpu_type_result} -eq 0 ];then
        return 0
    fi
    return 1
}