#!/bin/bash

conflict_script="/opt/oss/System_Commissioning/conflict_script"
conflict_result_path="/opt/oss/System_Commissioning/conflict_result"
arping_param_cfg="/opt/oss/System_Commissioning/conflict_ipv4.conf"
ping6_param_cfg="/opt/oss/System_Commissioning/conflict_ipv6.conf"

[ ! -d "${conflict_script}" ] && mkdir -p "${conflict_script}"
[ ! -d "${conflict_result_path}" ] && mkdir -p "${conflict_result_path}"

function write_check_script_ipv4() {
  node_ip=$1
  arping_nic=$2
  arping_ips=$3
  echo '#!/bin/bash
echo -n "" >/home/ossadm/arping_res.log
chmod 600 /home/ossadm/arping_res.log
chown ossadm:ossgroup /home/ossadm/arping_res.log

arping_info="{NEW_IPS}"
nics=$(echo ${arping_info} | awk -F"|" '\''{print $1}'\'')
ips=$(echo ${arping_info} | awk -F"|" '\''{print $2}'\'')
for ip in $(echo ${ips} | sed "s/;/ /g")
do
    for nic in $(echo ${nics} | sed "s/;/ /g")
    do
        sleep 1
        (
        arping -c 5 -I ${nic} ${ip} | grep "Received 0" &>/dev/null
        if [ $? -eq 0 ];then
            echo "arping|${nic}|${ip}|OK" >>/home/ossadm/arping_res.log
        else
            echo "arping|${nic}|${ip}|NOK" >>/home/ossadm/arping_res.log
        fi
        ) &
    done
done
wait' >"${conflict_script}/arping_${node_ip}.sh"

  sed -i "s/{NEW_IPS}/${arping_nic}|${arping_ips}/g" "${conflict_script}/arping_${node_ip}.sh"
}

function write_check_script_ipv6() {
  node_ip=$1
  ping6_nic=$2
  ping6_ips=$3
  echo '#!/bin/bash
echo -n "" >/home/ossadm/ping6_res.log
chmod 600 /home/ossadm/ping6_res.log
chown ossadm:ossgroup /home/ossadm/ping6_res.log

ping6_info="{NEW_IPS}"
nics=$(echo ${ping6_info} | awk -F"|" '\''{print $1}'\'')
ips=$(echo ${ping6_info} | awk -F"|" '\''{print $2}'\'')
for ip in $(echo ${ips} | sed "s/;/ /g")
do
    for nic in $(echo ${nics} | sed "s/;/ /g")
    do
        sleep 1
        (
        ping6 -c 5 -I ${nic} ${ip} 2>&1 | grep -E "0 received|ping6: connect" &>/dev/null
        if [ $? -eq 0 ];then
            echo "ping6|${nic}|${ip}|OK" >>/home/ossadm/ping6_res.log
        else
            echo "ping6|${nic}|${ip}|NOK" >>/home/ossadm/ping6_res.log
        fi
        ) &
    done
done
wait' >"${conflict_script}/ping6_${node_ip}.sh"

  sed -i "s/{NEW_IPS}/${ping6_nic}|${ping6_ips}/g" "${conflict_script}/ping6_${node_ip}.sh"
}

function exec_conflict_task() {
  node_ip=$1
  check_type=$2
  expect <<END
        spawn scp -p "${conflict_script}/${check_type}_${node_ip}.sh"  ossadm@${node_ip}:/opt/oss/${check_type}.sh
        expect {
        "*yes/no*" {send "yes\r";exp_continue}
}
        set timeout 300
        expect eof
END

  expect <<END >/dev/null 2>&1
        spawn ssh ${node_ip} "dos2unix /opt/oss/${check_type}.sh; bash /opt/oss/${check_type}.sh; rm -rf /opt/oss/${check_type}.sh"
        expect {
        "*yes/no*" {send "yes\r";exp_continue}
}
        set timeout 300
        expect eof
END
}

function get_conflict_result() {
  check_type=$1
  expect <<END
        spawn ssh ${node_ip} "cat /home/ossadm/${check_type}_res.log; rm -rf /home/ossadm/${check_type}_res.log"
        expect {
        "*yes/no*" {send "yes\r";exp_continue}
}
        set timeout 300
        expect eof
END
}

function build_check_res() {
  check_type=$1
  if [ -f "${conflict_result_path}/${check_type}_result.txt" ]; then
    rm -rf "${conflict_result_path}/${check_type}_result.txt"
  fi
  result_fale=$(ls ${conflict_result_path}/${check_type}_result_*.res | head -n 1)
  for line in $(cat "${result_fale}" | xargs); do
    ip=$(echo ${line} | awk -F'|' '{print $3}')
    conflict_res="True"
    for res_file in $(ls ${conflict_result_path}/${check_type}_result_*.res); do
      grep -w ${ip} ${res_file} | grep "NOK" &>/dev/null
      if [ $? -eq 0 ]; then
        conflict_res="False"
        grep -w ${ip} ${res_file} >>${conflict_result_path}/${check_type}_result.txt
        break
      fi
    done
    if [ "${conflict_res}" == "True" ]; then
      echo "${check_type}|eth-|${ip}|OK" >>${conflict_result_path}/${check_type}_result.txt
    fi
  done
}

function Main() {
  for ip_info in $(grep "^Arping" ${arping_param_cfg}); do
    old_ip=$(echo ${ip_info} | awk -F'|' '{print $2}')
    new_ips=$(echo ${ip_info} | awk -F'|' '{print $4}')
    arping_nic=$(echo ${ip_info} | awk -F'|' '{print $3}')
    write_check_script_ipv4 ${old_ip} ${arping_nic} ${new_ips}
    (
      exec_conflict_task ${old_ip} "arping"
      get_conflict_result "arping" | grep "^arping" >>"${conflict_result_path}/arping_result_${old_ip}.res"
    ) &
  done
  wait
  for ip_info in $(grep "^Ping6" ${ping6_param_cfg}); do
    old_ip=$(echo ${ip_info} | awk -F'|' '{print $2}')
    new_ips=$(echo ${ip_info} | awk -F'|' '{print $4}')
    ping6_nic=$(echo ${ip_info} | awk -F'|' '{print $3}')
    write_check_script_ipv6 ${old_ip} ${ping6_nic} ${new_ips}
    (
      exec_conflict_task ${old_ip} "ping6"
      get_conflict_result "ping6" | grep "^ping6" >>"${conflict_result_path}/ping6_result_${old_ip}.res"
    ) &
  done
  wait

  build_check_res "arping"
  build_check_res "ping6"
}

Main &>"${conflict_script}/conflict_ip.log"
