#!/bin/bash

# 用于恢复由于Easysuite修改的配置项
recover_sshd_for_tunnel()
{
    sed -i "/.*#Easysuite$/d" /etc/ssh/sshd_config
}

# 解锁euler或者suse系统 root用户由于连不上锁定问题
unlock_root_user()
{
    faillock --user root --reset
    echo "The value of 'faillock --user root --reset' result=$?" >> /opt/commissioning/config_os_mediation_log.log
    pam_tally2 -r -u root
    echo "The value of 'pam_tally2 -r -u root' result=$?" >> /opt/commissioning/config_os_mediation_log.log
}

Main()
{
    if [ -f "/opt/commissioning/reboot.flag" ];then
        rm -rf "/opt/commissioning/reboot.flag"
    fi
    osMediationPkg=`ls /opt/ | grep "^iMasterNCE.*\OSMediation_linux-.*64.zip$" | grep -v grep`
    if [ "$3" == "-productname" ]
    then
        productname=$4
        osMediationPackage=".*${productname}.*\OSMediation_linux-.*64.zip"
        osMediationPkg=`ls /opt/ | grep "^${osMediationPackage}$" | grep -v grep`
    fi

    recover_sshd_for_tunnel

    rm -rf /opt/NCE_OsMediation
    unzip -oq /opt/"$osMediationPkg" -d /opt/NCE_OsMediation
    chmod -R 750 /opt/NCE_OsMediation

    echo "es_input: all_os_default_passwd"
    read -rs all_os_default_passwd
    if [ "X${all_os_default_passwd}" == "X" ];then
      OperateLog "error" "Error: get all_os_default_passwd failed."
      exit 1
    fi

    if [ "$2" == "id_sek_select_yes" ]
    then
		cd /opt/NCE_OsMediation && { echo -e "${all_os_default_passwd}";echo -e "${all_os_default_passwd}"; } | bash install.sh
        result_tmp=$?
        time_tmp=`date "+%Y-%m-%d %H:%M:%S"`
        echo "${time_tmp} The value of result=${result_tmp}" >> /opt/commissioning/config_os_mediation_log.log
        if [ ${result_tmp} -eq 1 ];then
            return ${result_tmp}
        fi
        if [ -f "/opt/SEK/cmd/SetEnv.sh" ];then
            cd /opt/SEK/cmd;bash SetEnv.sh
            unlock_root_user
            return ${result_tmp}
        fi
        unlock_root_user
        return ${result_tmp}
    else
		    cd /opt/NCE_OsMediation && { echo -e "${all_os_default_passwd}";echo -e "${all_os_default_passwd}"; } | bash install.sh
        result_tmp=$?
        time_tmp=`date "+%Y-%m-%d %H:%M:%S"`
        echo "${time_tmp} The value of result=${result_tmp}" >> /opt/commissioning/config_os_mediation_log.log
        return ${result_tmp}
    fi
    rm -rf /opt/NCE_OsMediation
}

function checkproduct()
{
    check_product_result="false"
    productname="NCE"
    if [ ! -f "/opt/oss/manager/tools/resmgr/queryproduct.sh" ]
    then
        check_product_result="false"
    else
        #检查节点是否已添加
        if [ -f /opt/commissioning/product/${productname} ];then
            rm -rf /opt/commissioning/product/${productname}
        fi
        su - ossadm -c "mkdir -p /opt/commissioning/product/${productname}"

        su - ossadm -c "cd /opt/oss/manager/tools/resmgr && bash queryproduct.sh -pn all -output /opt/commissioning/product/${productname} > /dev/null 2>&1"
        if [ $? -eq 0 ];then
            node_file=`ls /opt/commissioning/product/${productname} | grep node | grep json`
            commissioning_node=`ifconfig -a | grep inet | grep -v 127.0.0.1 | grep -v inet6 | awk '{print $2}' | tr -d "addr:"`
            for node in ${commissioning_node}
            do
                for file in ${node_file}
                do
                    check_node=`cat /opt/commissioning/product/${productname}/${file} | grep -w ${node}`
                    if [ -n "${check_node}" ];then
                        echo "The commissioning node already exists in the product."
                        check_product_result="true"
                        rm -rf /opt/commissioning/product/${productname}
                        return 0
                    fi
                done
            done
        fi
        rm -rf /opt/commissioning/product/${productname}
    fi
}

checkproduct
if [ "${check_product_result}" == "true" ]
then
    exit 0
fi

#执行OS_Mediation
Main $*
result_os_mediation=$?
if [ ${result_os_mediation} -eq 0 ];then
    echo "Executed successful"
    echo "The value is ${result_os_mediation}, executed successful" >> /opt/commissioning/config_os_mediation_log.log
else
    echo "Executed failed"
    echo "The value is ${result_os_mediation}, executed failed" >> /opt/commissioning/config_os_mediation_log.log
fi
