#!/bin/bash
#########################################
# 功能描述：通过OMP节点查询产品信息
#########################################
MACHINE_MACHINE_ACCOUNT=$1
echo ${MACHINE_MACHINE_ACCOUNT}

function query_product_info()
{
    query_product_path="/opt/oss/manager/tools/resmgr/queryproduct.sh"
    if [ ! -x $query_product_path ];then
        echo "Query product infomation failure, because this ip is not omp!"
        exit 1
    fi
    if [ -f "/opt/oss/manager/etc/sysconf/nodelists.json" ];then
        cp /opt/oss/manager/etc/sysconf/nodelists.json /home/ossadm/org_product_info
    fi

    sudo -i -u ${MACHINE_MACHINE_ACCOUNT} -- sh -c "bash /opt/oss/manager/tools/resmgr/queryproduct.sh  -pn all -output /home/ossadm/org_product_info"
    sudo -i -u ${MACHINE_MACHINE_ACCOUNT} -- sh -c "bash /opt/oss/manager/tools/sysmt/querylvs.sh -pn NCE -output /home/ossadm/org_product_info/lvs_network.json"
    mv /home/ossadm/org_product_info/product_NCECOMMONE.json /home/ossadm/org_product_info/product_NCE.json
    mv /home/ossadm/org_product_info/dbinfo_NCECOMMONE.json /home/ossadm/org_product_info/dbinfo_NCE.json
    mv /home/ossadm/org_product_info/networkinfo_NCECOMMONE.json /home/ossadm/org_product_info/networkinfo_NCE.json
    mv /home/ossadm/org_product_info/nodes_NCECOMMONE.json /home/ossadm/org_product_info/nodes_NCE.json
    if [ -f "/home/ossadm/org_product_info/product_NCE.json" ];then
        echo "query product info success!"
    else
        echo "Error: Failed to query product info."
        exit 1
    fi

    if [ -f "/home/ossadm/query_package.pyc" ]
      then
          QUERY_PACKAGE=query_package.pyc
      else
          if [ -f "/home/ossadm/query_package.py" ]
          then
              QUERY_PACKAGE=query_package.py
          fi
    fi

    if [ -f "/home/ossadm/${QUERY_PACKAGE}" ]
    then
      echo "start query packages info success!"
      TMOUT=0
      sudo -i -u ${MACHINE_MACHINE_ACCOUNT} -- sh -c ". /opt/oss/manager/bin/engr_profile.sh;export SSL_ROOT=/opt/oss/manager/etc/ssl;export CIPHER_ROOT=/opt/oss/manager/etc/cipher;python /home/ossadm/${QUERY_PACKAGE}"
      ret_code=$?
      if [[ ${ret_code} -ne 0 ]];then
        echo "query packages info failed"
        return ${ret_code}
      fi
      echo "finish query packages info success!"
    fi
}

output_path="/home/ossadm/org_product_info"
rm -rf $output_path && mkdir $output_path && chmod 700 $output_path && chown ossadm: $output_path

query_product_info
