#!/bin/bash

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

logFile="${curPath}/expansion_rollback.log"

OperateLog()
{
    BASH_PID=$$
    if [ ! -f ${logFile} ]
    then
        touch ${logFile}
        chmod 660 ${logFile}
        chown ossadm:ossgroup ${logFile}
    fi
    Level="INFO"
    echo $1 | grep -i "ERROR" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="ERROR"
    fi
    echo $1 | grep -i "WARN" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="WARN"
    fi
    echo $1 | grep -i "INFO" &>/dev/null
    if [ $? -eq 0 ]
    then
        Level="INFO"
    fi

    echo "[$(date '+%Y-%m-%d %H:%M:%S')] [${BASH_PID}] | ${Level} $2" | tee -a ${logFile}
}


Main()
{
    MACHINE_MACHINE_ACCOUNT=$1
    echo ${MACHINE_MACHINE_ACCOUNT}
    product_name=$2
    if [ -f ${logFile} ];then
        chmod 660 ${logFile}
        chown ossadm:ossgroup ${logFile}
    fi
    expansion_backup_dir="/opt/expansion_backup"
    # 防呆，结果文件
    if [ ! -f "${expansion_backup_dir}/expansion_rollback_add_product.log" ]
    then
        touch "${expansion_backup_dir}/expansion_rollback_add_product.log"
    fi
    if [[ -f "${expansion_backup_dir}/insert_user_message.pyc" ]]
    then
        INSERT_FILE=insert_user_message.pyc
    else
        if [[ -f "${expansion_backup_dir}/insert_user_message.py" ]]
        then
            INSERT_FILE=insert_user_message.py
        else
            OperateLog "ERROR" "Can not find insert_user_message.py/pyc"
            return 1
        fi
    fi
    OperateLog "INFO" "Start to execute insert_user_message.py"
    su - ${MACHINE_MACHINE_ACCOUNT} -c ". /opt/oss/manager/bin/engr_profile.sh; python ${expansion_backup_dir}/${INSERT_FILE} ${expansion_backup_dir}/nodes_${product_name}.json"
    ret_code_2=$?
    if [[ ${ret_code_2} -ne 0 ]];then
        OperateLog "ERROR"  "insert message failed"
        return ${ret_code_2}
    fi
    OperateLog "INFO" "Start to execute setproductinfo.sh"
    su - ${MACHINE_MACHINE_ACCOUNT} -c "cd /opt/oss/manager/tools/resmgr && bash setproductinfo.sh -product ${expansion_backup_dir}/product_${product_name}.json -nodes ${expansion_backup_dir}/nodes_${product_name}.json"
    ret_code_3=$?
    if [[ ${ret_code_3} -ne 0 ]];then
        OperateLog "ERROR"  "Add product failed retcode ${ret_code_3}"
        return ${ret_code_3}
    fi
}

Main $*
echo $? > "${expansion_backup_dir}/expansion_rollback_add_product.log"
exit $?
