@rem Copyright Huawei Technologies Co., Ltd. 2010-2020. All rights reserved.
@rem Description: the file to start EasySuite package
@echo off
cd /d %~dp0
echo Starting, please wait...
:begin
    set HOST=localhost
    set PORT=19090
    set SEE_MASK_NOZONECHECKS=1
    set EASYSUITEPATH=%~dp0\easysuite
    set EASYSUITESYSTEMPATH=C:\Windows\System32\wbem
    set PATH=%EASYSUITEPATH%\3rdparty\Python39;%EASYSUITEPATH%\3rdparty\Python39\Lib;%EASYSUITEPATH%\3rdparty\Python39\DLLs;%EASYSUITEPATH%\lib;%EASYSUITESYSTEMPATH%;%PATH%
    set PYTHONPATH=%EASYSUITEPATH%;%EASYSUITEPATH%\3rdparty\Python39\Lib;%EASYSUITEPATH%\lib
    set PYTHONHOME=%EASYSUITEPATH%\3rdparty\Python39
    set PYTHONUSERBASE=%EASYSUITEPATH%\3rdparty\Python39

    rem checkEnv
    goto checkEnv

    exit

:getLength

    set /a num+=1
    set CURRENTPATH=%CURRENTPATH:~0,-1%
    if defined CURRENTPATH goto :getLength
    if %num% GTR 80 (
        echo The current path is too long, more than 80 characters!
        pause
        exit
    )

    netstat -ano|findstr %PORT%|findstr :0 >nul 2>&1
    set result=%ERRORLEVEL%
    if %result%==0 (
        echo Port %PORT% is already occupied, you can execute ^"stop.bat^" release!
        pause
        exit
    ) else (
        goto loadMigrateSolution
    )

:loadMigrateSolution
    dir %EASYSUITEPATH%\utils\migrate\load_migrate_solution\file_handling\load_migration_process.py >nul 2>&1 || dir %EASYSUITEPATH%\utils\migrate\load_migrate_solution\file_handling\load_migration_process.pyc >nul 2>&1
    if %ERRORLEVEL%==0 (
        %EASYSUITEPATH%\3rdparty\Python39\python.exe -c "import sys; sys.path.append(r'%EASYSUITEPATH%'); from utils.migrate.load_migrate_solution.file_handling.load_migration_process import load_process; load_process()" >nul 2>&1
    )else (
        echo Start failed, the file %EASYSUITEPATH%\utils\migrate\load_migrate_solution\file_handling\load_migration_process.py^(c^) does not exist!
        pause
        exit
    )
    set result=%ERRORLEVEL%
    if %result%==2 (
        echo Loading MigrateSolution failed, MigrateSolution signature file check error.
        pause
    )
    if %result%==3 (
        echo Loading MigrateSolution failed, MigrateSolution name error.
        pause
    )
    if %result%==4 (
        echo Loading MigrateSolution failed, MigrateSolution inner error.
        pause
        exit
    )
    if %result%==0 (
        echo Loading MigrateSolution succeeded.
    )
    goto pluginPrepare

:checkEnv
    set flag=False
    wmic os get caption | findstr 11 >nul
    set result=%ERRORLEVEL%
    if %result%==0 (
        set flag=True
    )
    wmic os get caption | findstr 10 >nul
    set result=%ERRORLEVEL%
    if %result%==0 (
        set flag=True
    )
    wmic os get caption | findstr 8 >nul
    set result=%ERRORLEVEL%
    if %result%==0 (
        set flag=True
    )
    wmic os get caption | findstr 2012 >nul
    set result=%ERRORLEVEL%
    if %result%==0 (
        set flag=True
    )
    wmic os get caption | findstr 2016 >nul
    set result=%ERRORLEVEL%
    if %result%==0 (
        set flag=True
    )
    wmic os get caption | findstr 2008 >nul
    set result=%ERRORLEVEL%
    if %result%==0 (
        set flag=False
    )
    if %flag%==False (
        echo The current operating system is not supported, only support Windows 8/10/11 and Windows Server 2012/2016 system!
        pause
        exit
    )

    dir %EASYSUITEPATH% >nul 2>&1
    if %ERRORLEVEL% NEQ 0 (
        echo Start failed, the path is too long, or the path may contain spaces or invalid characters, please check!
        pause
        exit
    )
    dir %EASYSUITEPATH%\startup\bin\start_param_check.py >nul 2>&1 || dir %EASYSUITEPATH%\startup\bin\start_param_check.pyc >nul 2>&1
    if %ERRORLEVEL%==0 (
        %EASYSUITEPATH%\3rdparty\Python39\python.exe -c "from startup.bin.start_param_check import start_param_check; start_param_check()" >nul 2>&1
    ) else (
        echo Start failed, the file easysuite\startup\bin\start_param_check.py^(c^) does not exist, or the current path is too long!
        pause
        exit
    )

    set result=%ERRORLEVEL%
    if %result%==1 (
        echo The current path is not supported, please confirm the path only consists of letters, numbers, underlined!
        pause
        exit
    )

    set CURRENTPATH=%~dp0
    set num=0
    set "CURRENTPATH=%CURRENTPATH:\=%"

    goto getLength

:pluginPrepare
    echo Start loading ESSolution package, don't close this window before it auto close...
    dir %EASYSUITEPATH%\startup\bin\start_plugin_prepare.py >nul 2>&1 || dir %EASYSUITEPATH%\startup\bin\start_plugin_prepare.pyc >nul 2>&1
    if %ERRORLEVEL%==0 (
        %EASYSUITEPATH%\3rdparty\Python39\python.exe -c "from startup.bin.start_plugin_prepare import start_plugin_prepare; start_plugin_prepare()" >nul 2>&1
    )else (
        echo Start failed, the file %EASYSUITEPATH%\startup\bin\start_plugin_prepare.py^(c^) does not exist!
        pause
        exit
    )
    set result=%ERRORLEVEL%
    if %result%==2 (
        echo Unzip Solution or Migrate zipfile failed, please check whether the zipfile is damaged or the current path is too long.
        pause
        exit
    )
    if %result%==3 (
        echo Copy template files to '/easysuite/plugin/' failed, because the current path is too long.
        pause
        exit
    )
    if %result%==11 (
        echo Copy template files to '/var/software/escompontent/software' failed, because the current path is too long.
        pause
        exit
    )
    if %result%==5 (
        echo ESSolution or ESMigrate install package signature check failed.
        pause
        exit
    )
    if %result%==6 (
        echo Make path '/var/software/Solution' or '/var/software/Migrate' failed.
        pause
        exit
    )
    if %result%==8 (
        echo ESSolution or ESMigrate signature file cms or crl does not exist.
        pause
        exit
    )
    if %result%==9 (
        echo More than one ESSolution exists in the current path. Please remove the extra software packages and try again.
        pause
        exit
    )
    if %result%==10 (
        echo No matching ESSolution package is available and does not need to be loaded.
    )
    if %result%==0 (
        echo Loading ESSolution product_apps success.
    )
    goto setDBAuth

:setDBAuth
    set DBPATH=%~dp0\easysuite\db
	set FILEPATH=%~dp0\easysuite\db\authenticate.flag
    if exist %FILEPATH% (
        move %FILEPATH% %~dp0\authenticate.flag.bak >nul 2>&1
		if not exist %~dp0\authenticate.flag.bak (
			echo Insufficient permissions, please check the permissions of the current user.
			pause
			exit
		)
        move %~dp0\authenticate.flag.bak %FILEPATH% >nul 2>&1
        echo "authenticate.flag exist already, nothing need change. %date% %time%" >> %FILEPATH%
        goto startServer
    )
    %EASYSUITEPATH%\3rdparty\Python39\python.exe -m easysuite.replace_key true
    if %errorlevel%==0 (
        echo The key is successfully replaced.
    ) else (
        echo Failed to replace the key.
        pause
        exit
    )
    echo "Start delete Authenticated Users Group rights at %date% %time%" > %FILEPATH%
    set str_a=false
    setlocal enabledelayedexpansion
    FOR /F "DELIMS=" %%i in ('ICACLS %DBPATH%') do (
        echo %%i | find "Authenticated Users">nul &&set str_a=true||set str_a=false
        if "!str_a!"  == "true" (
            ICACLS %DBPATH% /inheritance:d >nul 2>&1
            ICACLS %DBPATH% /remove:g "Authenticated Users" >nul 2>&1
            ICACLS %DBPATH% /grant:r "%USERDOMAIN%\%USERNAME%:(OI)(CI)F" >nul 2>&1
            echo "Delete Authenticated Users Group rights at %date% %time%"  >> %FILEPATH%
        )
    )
    
    goto startServer
    
rem start server
:startServer
    if exist %EASYSUITEPATH%\manage.py (
        goto runSslserver
    ) else if exist %EASYSUITEPATH%\manage.pyc (
        goto runSslserver
    ) else (
        echo Start failed, the file %EASYSUITEPATH%\manage.py^(c^) does not exist!
        pause 
        exit
    )

rem run sslserver
:runSslserver
    set hour=%time:~,2%
    if "%time:~,1%"==" " set hour=0%time:~1,1%
    set /a ini_time=(%time:~0,2%)*3600+(1%time:~3,2%)*60+(1%time:~6,2%) >nul 2>&1
    start /b %EASYSUITEPATH%\runsslserver.bat >nul 2>&1
    echo Starting the server, please wait...
    goto listenServer
    
	
rem listen server
:listenServer
    netstat -ano|findstr %PORT%|findstr :0 >nul 2>&1
    set result=%ERRORLEVEL%
    if %result%==0 (
        echo Start the server successfully!
        eventcreate /T INFORMATION /L APPLICATION /ID 100 /D "start EasySuite successfully." >nul 2>&1
        echo [%date:~0,4%-%date:~5,2%-%date:~8,2% %hour%:%time:~3,2%:%time:~6,2%]start easysuite >> ./var/run/log/easysuite.log >nul 2>&1
        goto zip_process
    ) else (
        goto isServerTimeout
    )

rem check server timeout
:isServerTimeout
    ping -n 1 127.1 >nul 2>&1
    set /a end_time=(%time:~0,2%)*3600+(1%time:~3,2%)*60+(1%time:~6,2%) >nul 2>&1
    set /a internal=%end_time%-%ini_time% >nul 2>&1
    
    if %internal% GEQ 120 (
        echo Failed to start the server!
        eventcreate /T ERROR /L APPLICATION /ID 100 /D "start EasySuite failed." >nul 2>&1
        pause 
        exit
    ) else (
        goto listenServer 
    )
    
:startBrowser
    echo %HOST%| findstr : >nul && (
        set HOST=[%HOST%]
    )
    dir %EASYSUITEPATH%\startup\bin\search_browser.py >nul 2>&1 || dir %EASYSUITEPATH%\startup\bin\search_browser.pyc >nul 2>&1
    if %ERRORLEVEL%==0 (
        %EASYSUITEPATH%\3rdparty\Python39\python.exe -c "from startup.bin.search_browser import search_browser; search_browser()" >nul 2>&1
    ) else (
        echo Start failed, the file %EASYSUITEPATH%\startup\bin\search_browser.py^(c^) does not exist!
        pause 
        exit
    )

    set result=%ERRORLEVEL%
    if %result%==11 (
        start /b chrome.exe "https://%HOST%:%PORT%"
    ) else if %result%==12 (
        start /b firefox.exe "https://%HOST%:%PORT%"
    ) else if %result%==13 (
        start /b msedge.exe "https://%HOST%:%PORT%"
    ) else (
        echo Please check whether the browser chrome 94+/firefox 92+/microsoft-edge 94+/Firefox ESR 91+ is installed correctly, If the browser cannot be displayed, please visit https://%HOST%:%PORT% using chrome 94+/firefox 92+/microsoft-edge 94+/Firefox ESR 91+.
        pause
    )
    exit

:zip_process
    echo Start zip software package.waiting...
    dir %EASYSUITEPATH%\startup\bin\zip_process.py >nul 2>&1 || dir %EASYSUITEPATH%\startup\bin\zip_process.pyc >nul 2>&1
    if %ERRORLEVEL%==0 (
        %EASYSUITEPATH%\3rdparty\Python39\python.exe -c "from startup.bin.zip_process import zip_process; zip_process()" >nul 2>&1
    )else (
        echo zip failed, the file %EASYSUITEPATH%\startup\bin\zip_process.py^(c^) does not exist!
        pause
        exit
    )
    set result=%ERRORLEVEL%
    if %result%==2 (
        echo Unzip Solution or Migrate zipfile failed, please check whether the zipfile is damaged or the current path is too long.
        pause
        exit
    )
    if %result%==3 (
        echo Copy template files to '/var/software/escompontent/software' failed, because the current path is too long.
        pause
        exit
    )
    if %result%==4 (
        echo Zip '*DeployTemplate.zip' or '*Expansion.zip' or 'Migrate.zip' failed.
        pause
        exit
    )
    if %result%==1 (
        echo Zip software package failed.
        pause
        exit
    )
    if %result%==0 (
        echo Zip software package succeeded.
        goto startBrowser
    )