@rem Copyright Huawei Technologies Co., Ltd. 2010-2020. All rights reserved.
@rem Description: The file to stop EasySuite
@echo off

cd /d %~dp0

:begin
    set SEE_MASK_NOZONECHECKS=1
	set PORT=19090
    call:checkServer %PORT%
    exit
	
:checkServer
	set PORT=%1
	netstat -ano|findstr %PORT%|findstr :0 >nul 2>&1

	set result=%ERRORLEVEL%
	if %result%==0 (
		set /a ini_time=^(%time:~0,2%^)*3600+^(1%time:~3,2%^)*60+^(1%time:~6,2%^) >nul 2>&1
		set /a ini_num=1
		call:stopServer %PORT%
	) else (
		echo No server port:%PORT% is running.
		echo Stop the server port:%PORT% successfully!
		ping -n 3 127.1 >nul 2>&1
	)
	goto :eof
	
:stopServer
	set PORT=%1
	for /f "tokens=5" %%a in ('netstat -ano^|findstr %PORT%^|findstr :0') do taskkill /f /t /fi "pid eq %%a" 
	call:isNumout %PORT%
	goto :eof

:checkResult
	set PORT=%1
	netstat -ano|findstr %PORT%|findstr :0 >nul 2>&1

	set result=%ERRORLEVEL%
	if %result%==0 (
		call:stopServer %PORT%
	) else (
		echo Stop the server port:%PORT% successfully!
		eventcreate /T INFORMATION /L APPLICATION /ID 100 /D "stop EasySuite successfully." >nul 2>&1
		ping -n 3 127.1 >nul 2>&1
		call:logStop
		goto :eof
	)
	
	
rem check server times out
:isNumout
	set PORT=%1
	ping -n 1 127.1 >nul 2>&1
	
	if %ini_num% GEQ 3 (
		echo Failed to stop the server! Please check whether the EasySuite is runned by another user!
		eventcreate /T ERROR /L APPLICATION /ID 100 /D "stop EasySuite failed." >nul 2>&1
		pause 
	) else (
		set /a ini_num+=1
		call:checkResult %PORT%
	)
	goto :eof
	
:logStop
	set hour=%time:~,2%
	if "%time:~,1%"==" " set hour=0%time:~1,1%
	echo [%date:~0,4%-%date:~5,2%-%date:~8,2% %hour%:%time:~3,2%:%time:~6,2%]stop easysuite >> ./var/run/log/easysuite.log
	goto :eof
