#!/bin/bash
installDir=/opt/expansion

#create action.json check file
createCheckFile()
{
   
    echo "#!/bin/bash
echo  RESULT:1   
   ">/opt/expansion/check_addproduct_result.sh
 
   chmod 550 /opt/expansion/check_addproduct_result.sh
}

#getWorkPath
getWorkPath()
{
    dir=`dirname $0`
    ispointstart=`echo $dir|awk -F/ '{print $1}'`
    if [ "$ispointstart" = "." ]
    then
        dir=`echo $dir|sed 's/^.//'`
        curPath="`pwd`$dir"
    elif [ "$ispointstart" = ".." ]
    then
        curPath="`pwd`/$dir"
    else
        curPath="$dir"
    fi
    return 0
}
#check root user
checkUser()
{
    USER_ID=`id -u`
    if [ $USER_ID -ne 0 ]
    then
        echo "Run the script as the root user."
        return 1
    fi

    return 0
}


#log
OperateLog()
{
    if [ -f "/opt/NCEICMR/scripts/OperationLog/businessoperatelog.sh" ]
    then
        bash /opt/NCEICMR/scripts/OperationLog/businessoperatelog.sh "$1" "$2"
        return
    fi
}

getcheckResult()
{
   if [ $1 -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100 && rm -rf /opt/expansion/check_addproduct_result.sh
   ">/opt/expansion/check_addproduct_result.sh
   else
       echo "#!/bin/bash
echo  RESULT:255 && rm -rf /opt/expansion/check_addproduct_result.sh
   ">/opt/expansion/check_addproduct_result.sh
   fi
   chmod 550 /opt/expansion/check_addproduct_result.sh > /dev/null 2>&1
}

checkPackage()
{
    #1：检查模板文件
    if [ ! -f $installDir/nodes_NCE.json ] || [ ! -f  $installDir/product_NCE.json ]
    then
        OperateLog "Error: the nodes.json or product.json is not exists, rendering the install_uniep.sh script failed." "error"
        return 1
    fi
}

addproduct()
{
    chown ossadm:ossgroup $installDir
    chown ossadm:ossgroup $installDir/networkinfo_NCE.json
    ls -l /opt >> $installDir/addproduct.log
    ls -l $installDir >> $installDir/addproduct.log
    if [ $# -gt 0 ]
    then
        su - ossadm -c "cd /opt/oss/manager/tools/resmgr && bash setproductinfo.sh -product $installDir/product_NCE.json -nodes $installDir/nodes_NCE.json -networkinfo $installDir/networkinfo_NCE.json"
    else
        su - ossadm -c "cd /opt/oss/manager/tools/resmgr && bash setproductinfo.sh -product $installDir/product_NCE.json -nodes $installDir/nodes_NCE.json"
    fi
    exec_addproduct_result=$?
    echo $exec_addproduct_result > /opt/expansion_backup/rollback_add_product_flag
    if [ $exec_addproduct_result -ne 0 ]
    then
        OperateLog "Error: Failed to add product, rendering the install_uniep.sh script failed." "error"
        return 1
    fi
}

# 添加产品后置检查
post_check()
{
    # 初始化工具模块
    if [ -f "/opt/expansion/get_addproduct_ip.pyc" ]
    then
        EXPAND_FILE=get_addproduct_ip.pyc
    else
        if [ -f "/opt/expansion/get_addproduct_ip.py" ]
        then
            EXPAND_FILE=get_addproduct_ip.py
        else
            echo "Error: Can not find get_addproduct_ip file"
            return 1
        fi
    fi
    chown ossadm:ossgroup /opt/expansion/${EXPAND_FILE}
    chown ossadm:ossgroup /opt/expansion/check_coredump.sh
    node_ip_list=$(su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh; python /opt/expansion/${EXPAND_FILE}")
    # 遍历检查,以保证所有节点coredump存在,且权限正常
    local result_flag=0
    for node_ip in $(echo ${node_ip_list} | sed 's/,/ /g')
    do
        su - ossadm -c "bash /opt/expansion/check_coredump.sh ${node_ip}" &>/dev/null
        if [ $? -ne 0 ]
        then
            local result_flag=1
            OperateLog "Error" "The /opt/oss/log/NCE/coredump directory on the ${node_ip} node is abnormal."
        fi
        sleep 0.5
    done
    return ${result_flag}
}

fn_main()
{
    getWorkPath
    createCheckFile
    
    #检查登录用户
    checkUser
    if [ $? -ne 0 ]
    then
        OperateLog "Error: Failed to check the logged-in user, rendering the install_uniep.sh script failed." "error"
        return 1
    fi
    
    #检查部署文件
    checkPackage
    if [ $? -ne 0 ]
    then
        OperateLog "Error: Failed to check the package, rendering the install_uniep.sh script failed." "error"
        return 1
    fi

    bash ${curPath}/deal_empty_nodes.sh

    addproduct $*
    if [ $? -ne 0 ]
    then
        OperateLog "Error: Failed to add product, rendering the install_uniep.sh script failed." "error"
        return 1
    fi

    post_check
    if [ $? -ne 0 ]
    then
        OperateLog "Error: Failed to post_check, rendering the install_uniep.sh script failed." "error"
        return 1
    fi

    sleep 60
    return 0
}

fn_main $*
exec_result=$?
getcheckResult $exec_result
exit $exec_result