#!/bin/bash
#create action.json check file
createCheckFile()
{
   
    echo "#!/bin/bash
echo  RESULT:1   
   ">/opt/expansion/check_expansion_result.sh
 
   chmod 550 /opt/expansion/check_expansion_result.sh
}

#get expansion script execute result
getcheckResult()
{
   if [ $1 -eq 0 ]
   then
       echo "#!/bin/bash
echo  RESULT:100   
   ">/opt/expansion/check_expansion_result.sh
   else
       exit_code=$1
       echo "Error: expand.py exit with code ${exit_code}"
       echo "#!/bin/bash
echo  RESULT:255
   ">/opt/expansion/check_expansion_result.sh
   fi
   echo "rm -rf /opt/expansion/check_expansion_result.sh
   ">>/opt/expansion/check_expansion_result.sh
   chmod 550 /opt/expansion/check_expansion_result.sh
}

update_crl()
{
    crl_file_build="/opt/install/HuaweiRootCAsipCRLs.crl"
    crl_file_release="/opt/install/HuaweiRootCAsipCRLs_Release.crl"
    
    if [ ! -d "/tmp/oss" ]
    then
        mkdir "/tmp/oss"
        chown ossadm:ossgroup "/tmp/oss"
    fi

    if [ -d /opt/oss/manager/apps/UniEPService/tools/crlTools ]
    then
        curPath="/opt/oss/manager/apps/UniEPService/tools/crlTools"
    elif [ -d /opt/oss/manager/apps/UniEPLiteService/tools/crlTools ]
    then
        curPath="/opt/oss/manager/apps/UniEPLiteService/tools/crlTools"
    else
        LOG_FILE "INFO" "The update crl interface does not exist."
        exit
    fi

    if [ -f ${crl_file_build} ]
    then
        cp ${crl_file_build} "/tmp/oss"
        chmod 400 "/tmp/oss/HuaweiRootCAsipCRLs.crl"
        chown ossadm:ossgroup "/tmp/oss/HuaweiRootCAsipCRLs.crl"    
        excute_ord="huaweicrltool.sh -cmd replaceCrl -all -type BUILD_SIGN"
        su - ossadm -c "cd ${curPath} && echo 'y' | bash ${excute_ord}"
        RESULT=$?
        if [ ${RESULT} -ne 0 ]
        then
            OperateLog "error" "Error:update build crl failed"
        else
            OperateLog "info" "update build crl successfully"
        fi
    fi
    
    if [ -f ${crl_file_release} ]
    then
        cp ${crl_file_release} "/tmp/oss"
        chmod 400 "/tmp/oss/HuaweiRootCAsipCRLs_Release.crl"
        chown ossadm:ossgroup "/tmp/oss/HuaweiRootCAsipCRLs_Release.crl"
        if [ -f "/tmp/oss/HuaweiRootCAsipCRLs_Release.crl" ]
        then
            mv /tmp/oss/HuaweiRootCAsipCRLs_Release.crl /tmp/oss/cs_g2_crls.crl
        fi
        excute_ord="huaweicrltool.sh -cmd replaceCrl -all -type RELEASE_SIGN"
        su - ossadm -c "cd ${curPath} && echo 'y' | bash ${excute_ord}"
        RESULT=$?
        if [ ${RESULT} -ne 0 ]
        then
            OperateLog "error" "Error:update release crl failed"
        else
            OperateLog "info" "update release crl successfully"
        fi
    fi
}

Main()
{
    if [ -n "$1" ]
    then
      easysuite_task_uuid=$1
      echo "easysuite_task_uuid:${easysuite_task_uuid}"
    fi
    update_crl
    createCheckFile
    chown ossadm:ossgroup /opt/expansion
    chmod 770 /opt/expansion
    ls -l /opt >> /opt/expansion/roc_expand_product.log
    ls -l /opt/expansion >> /opt/expansion/roc_expand_product.log
    # 每次执行清空文件内容
    cat /dev/null > /opt/expansion_backup/expand_rc.txt
    # 如果已经扩容，执行重试脚本
    pyscript="/opt/expansion/expand_retry.py"
    if [ ! -f "${pyscript}" ]
    then
        pyscript="/opt/expansion/expand_retry.pyc"

    fi
    chown ossadm:ossgroup ${pyscript}
    su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh;python ${pyscript}"
    retry_code=$?
    # 返回100没有查到失败记录就重新创建任务
    if [ $retry_code -eq 100 ]
    then
        su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh;unbuffer ipmc_tool -cmd productmgr -o deployv2 -action SCALE_OUT -input /opt/expansion/input.json"
        expand_code=$?
        if [ $expand_code -ne 0 ]
        then
            echo "Error: Failed to expand product."
            # 如果返回码47 指产品安装失败 可以进行回退 product_restore.py
            return $expand_code
        fi
        return 0
    fi
    if [ $retry_code -eq 0 ]
    then
        echo "Success: success to expand product."
        return 0
    fi
    echo "Error: Failed to expand product."
    # 如果返回码47 指产品安装失败 可以进行回退 product_restore.py
    return 47
}


record_rollback_id()
{
  if [ $1 -eq 0 -o $1 -eq 47 ]
  then
    echo "start to record rollback id."
    record_rollback_pyscript="/opt/expansion/expand_record_rollback_id.py"
    if [ ! -f "${record_rollback_pyscript}" ]
    then
        record_rollback_pyscript="/opt/expansion/expand_record_rollback_id.pyc"
    fi
    chown ossadm:ossgroup ${record_rollback_pyscript}
    su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh;python ${record_rollback_pyscript} ${easysuite_task_uuid}"
    echo "record rollback id finished."
  fi
}

Main $*
exec_result=$?
echo "$exec_result" > /opt/expansion_backup/expand_rc.txt
record_rollback_id $exec_result
getcheckResult $exec_result
exit $?
