#!/bin/bash
installDir=/opt/install
echo "es_input: product_pwd_ftpuser"
read -rs product_pwd_ftpuser
if [ "X${product_pwd_ftpuser}" == "X" ];then
    OperateLog "error" "Error: get ftpuser passwd failed."
    exit 1
fi
product_pwd_ftpuser_encrypt=`{ echo -e "${product_pwd_ftpuser}\n${product_pwd_ftpuser}" ;}|su - ossadm -c "bash /opt/oss/manager/agent/bin/osskey -cmd encryptpasswd" 2>/dev/null`
echo "{
\"backupmode\": \"SFTP\",
\"NFS\": {
    \"nfsbackuppath\": \"/export/home/backup\"
},
\"SFTPList\": [
    {
    \"SFTPServerIPAddress\": \"$1\",
    \"username\": \"ftpuser\",
    \"password\": \"${product_pwd_ftpuser_encrypt}\",
    \"backuppath\": \"backup\"
    }
]
}" >$installDir/defaultBackServer.json
chmod 400 $installDir/defaultBackServer.json
chown ossadm:ossgroup $installDir/defaultBackServer.json
su - ossadm -c "bash /opt/oss/manager/tools/backuprestore/setglobalpara.sh -input $installDir/defaultBackServer.json"
if [ $? -ne 0 ];then
    echo "Failed to config backup server."
    echo "RESULT:255"
    exit 1
fi
echo "Succeeded to config backup server."
echo "RESULT:100"
exit 0
