#!/bin/bash
#脚本记录日志
if [ ! -d /var/preinstall ];then
    mkdir -p /var/preinstall
fi
logFile="/var/preinstall/init_env.log"
rm ${logFile} > /dev/null 2>& 1
touch ${logFile} > /dev/null 2>& 1
function LOG()
{
    if [ "$1" = "ERROR" ];then
        Level="ERROR"
    elif [ "$1" = "WARN" ];then
        Level="WARN"
    else
        Level="INFO"
    fi
    echo "`date +%Y`-`date +%m`-`date +%d` `date +%H`:`date +%M`:`date +%S`| ${Level} $2">>${logFile}
}

LOG "INFO" "RunCmd Set permission of /opt/install"
chmod -R 755 /opt/install >>${logFile} 2>&1
cd /opt/install
rm -rf /var/log/oss > /dev/null 2>&1
rm -rf /opt/oss/log > /dev/null 2>&1

#在应用节点上执行删除的操作，恢复环境
if [ -d /deploybaseagent ]
then
    LOG "INFO" "RunCmd clear deploybaseagent"
    rm -rf /deploybaseagent >>${logFile} 2>&1
    rm -rf /opt/DeployBaseAgent >>${logFile} 2>&1
    sed -i '/baseagent.sh/d' /etc/crontab > /dev/null 2>& 1
    sed -i '/baseagent.sh/d' /etc/crontab_bak > /dev/null 2>& 1
    rm -rf /tmp/oss >>${logFile} 2>&1
    rm -rf /var/log/oss/* >>${logFile} 2>&1
    rm -rf /etc/uuid/uuid.txt >>${logFile} 2>&1
    LOG "INFO" "Start-RunCmd:rm -rf /opt/oss"
    rm -rf /opt/oss >>${logFile} 2>&1
    LOG "INFO" "Finish-RunCmd:rm -rf /opt/oss"
    rm -rf /opt/mysql >>${logFile} 2>&1
    rm -rf /opt/redis >>${logFile} 2>&1
    ps -ef | grep ^ossadm | awk '{print $2}' | xargs kill -9 >>${logFile} 2>&1
    pkill nginx >>${logFile} 2>&1
    LOG "INFO" "Finish runCmd clear deploybaseagent"
fi

if [ -d /opt/sybase ]
then
    rm -rf /opt/sybase >>${logFile} 2>&1
    pid_list=`ipcs -m | grep 3002 | awk '{print $2}'`
    for pid in ${pid_list}
    do
    {
        ipcrm -m ${pid} >>${logFile} 2>&1
    }
    done
fi

#检查是否有目录占用
LOG "INFO" "Start check /opt/oss"
#检查目录文件列表
su ossadm -c "/opt/*/manager/agent/tools/shscript/uninstall.sh -f" >>${logFile} 2>&1
ps -ef | grep -E 'admrun|ossadm|dbuser|ossuser|ossrun|secuser|iscript' |grep -v osconfig | grep -vw grep | awk '{print $2}' | xargs kill -9 >>${logFile} 2>&1
yes | rm -rf /opt/oss /opt/cloud /opt/redis /opt/zenith /opt/pub /home/ossadm/.ssh/  >>${logFile} 2>&1
