#! /bin/bash

action_type=$1

if [[ "$(whoami)" != 'root' ]];then
    echo "You do not have the permission to perform the operation. Switch to the root user to perform the operation."
    exit 1
fi

logger  -p local0.info "user: `who -m | cut -d\( -f2 |cut -d\) -f1`, Begin to execute ${BASH_SOURCE}"
echo "Begin to reinforce ssh..."

if [ $# -ne 1 ];then
    echo "Usage: bash ssh_reinforce.sh [active|deactive]"
    logger  -p local0.info "user: `who -m | cut -d\( -f2 |cut -d\) -f1`, execute ${BASH_SOURCE} failed: invalid args."
    exit 1
fi



args_check()
{
    if [[ ${action_type} != "active" ]] && [[ ${action_type} != "deactive" ]];then
        echo "Usage: bash ssh_reinforce.sh [active|deactive]"
        logger  -p local0.info "user: `who -m | cut -d\( -f2 |cut -d\) -f1`, execute ${BASH_SOURCE} failed: invalid args."
        exit 1
    fi
}

backup_config()
{
    cp -r /etc/ssh/sshd_config /etc/ssh/bak_sshd_config
    cp -r /etc/ssh/ssh_config /etc/ssh/bak_ssh_config
}

add_rekey_limit()
{
    cat /etc/ssh/bak_sshd_config | grep "RekeyLimit" | grep -v "^#" >/dev/null 2>&1
    if [[ $? == 0 ]];then
        sed '/^[^#].*ekeyLimit.*$/c RekeyLimit 1G 1h' /etc/ssh/bak_sshd_config > /etc/ssh/bak_sshd_config_temp
    else
        sed '/[^#].*ekeyLimit.*$/c RekeyLimit 1G 1h' /etc/ssh/bak_sshd_config > /etc/ssh/bak_sshd_config_temp
    fi
    res_sshd=$?
    mv /etc/ssh/bak_sshd_config_temp /etc/ssh/bak_sshd_config

    cat /etc/ssh/bak_ssh_config | grep "RekeyLimit" | grep -v "^#" >/dev/null 2>&1
    if [[ $? == 0 ]];then
        sed '/^[^#].*ekeyLimit.*$/c RekeyLimit 1G 1h' /etc/ssh/bak_ssh_config > /etc/ssh/bak_ssh_config_temp
    else
        sed '/[^#].*ekeyLimit.*$/c RekeyLimit 1G 1h' /etc/ssh/bak_ssh_config > /etc/ssh/bak_ssh_config_temp
    fi
    res_sshc=$?
    mv /etc/ssh/bak_ssh_config_temp /etc/ssh/bak_ssh_config
    
    if [[ ${res_sshd} == 0 ]] && [[ ${res_sshc} == 0 ]];then
        return 0
    fi
    return 1
}

del_rekey_limit()
{
    sed '/RekeyLimit/ s/^/#/g' /etc/ssh/bak_sshd_config > /etc/ssh/bak_sshd_config_temp
    res_sshd=$?
    mv /etc/ssh/bak_sshd_config_temp /etc/ssh/bak_sshd_config

    sed '/RekeyLimit/ s/^/#/g' /etc/ssh/bak_ssh_config > /etc/ssh/bak_ssh_config_temp
    res_sshc=$?
    mv /etc/ssh/bak_ssh_config_temp /etc/ssh/bak_ssh_config

    if [[ ${res_sshd} == 0 ]] && [[ ${res_sshc} == 0 ]];then
        return 0
    fi
    return 1
}

modify_config()
{
    mv /etc/ssh/bak_sshd_config /etc/ssh/sshd_config
    mv /etc/ssh/bak_ssh_config /etc/ssh/ssh_config
    chmod 644 /etc/ssh/ssh_config
    systemctl restart sshd.service
}

active()
{
    backup_config
    add_rekey_limit
    if [[ $? == 0 ]];then
        modify_config
        logger  -p local0.info "user: `who -m | cut -d\( -f2 |cut -d\) -f1`, action: active. execute ${BASH_SOURCE} success."
        echo "ssh_reinforce execute success, action: active."
    else
        logger  -p local0.info "user: `who -m | cut -d\( -f2 |cut -d\) -f1`, action: active. execute ${BASH_SOURCE} failed."
        echo "ssh_reinforce execute failed, action: active."
    fi
}

deactive()
{
    backup_config
    del_rekey_limit
    if [[ $? == 0 ]];then
        modify_config
        logger  -p local0.info "user: `who -m | cut -d\( -f2 |cut -d\) -f1`, action: deactive. execute ${BASH_SOURCE} success."
        echo "ssh_reinforce execute success, action: deactive."
    else
        logger  -p local0.info "user: `who -m | cut -d\( -f2 |cut -d\) -f1`, action: deactive. execute ${BASH_SOURCE} failed."
        echo "ssh_reinforce execute failed, action: deactive."
    fi
}

main()
{
    args_check
    if [[ ${action_type} == "active" ]];then
        active
    fi
    if [[ ${action_type} == "deactive" ]];then
        deactive
    fi
}

main
