#!/bin/bash

SCRIPT_NAME=$(basename $0)
EXEC_SCRIPT=/usr/local/bin/${SCRIPT_NAME}
FILE_LOG=/var/log/insight/delete_upgrade_dir.log

install_delete_server()
{
    uninstall_delete_server

    if [[ -f /etc/upragde_timestamp ]];
    then
        rm -rf /etc/upragde_timestamp
    fi
    local cur_timestamp=$(date +%s)
    echo "upgrade timestamp:${cur_timestamp}" >> /etc/upragde_timestamp
    echo "ugrade time:$(date -d @${cur_timestamp})" >> /etc/upragde_timestamp
    cat /etc/upragde_timestamp >> ${FILE_LOG}

    mkdir -p /usr/local/bin/ >/dev/null
    cp $0 ${EXEC_SCRIPT}
    crontab -l >tmp_conf
    sed "/${SCRIPT_NAME}/d" tmp_conf >tmp_conf_new
    mv tmp_conf_new tmp_conf
    echo "30 0 * * *  sh "${EXEC_SCRIPT}" run >/dev/null 2>&1" >> tmp_conf && crontab tmp_conf && rm -f tmp_conf
    if [[ $? != 0 ]];
    then
        echo "failed to install delete_upgrade_dir cron" >> ${FILE_LOG}
        return 1
    fi
    echo "success to install delete_upgrade_dir cron" >> ${FILE_LOG}
    return 0
}

uninstall_delete_server()
{
    if [[ -f /etc/upragde_timestamp ]];
    then
        rm -rf /etc/upragde_timestamp
    fi

    crontab -l >tmp_conf
    if [[ $? != 0 ]]; then
        echo "not crontab"  >> ${FILE_LOG}
        return 0
    fi
    sed "/${SCRIPT_NAME}/d" tmp_conf >tmp_conf_new && crontab tmp_conf_new && rm -f tmp_conf && rm -f tmp_conf_new
    if [[ $? != 0 ]];
    then
        echo "failed to uninstall delete_upgrade_dir cron" >> ${FILE_LOG}
        return 1
    fi

    echo "success to uninstall delete_upgrade_dir cron" >> ${FILE_LOG}
    return 0
}

run_delete_server()
{
    if [[ ! -f /etc/upragde_timestamp ]];then
        echo "no upragde_timestamp.please confirm" >> ${FILE_LOG}
        return 0
    fi
    local cur_timestamp=$(date +%s)
	local upgrade_timestamp=$(cat /etc/upragde_timestamp | grep "upgrade timestamp" | awk -F ':' '{print $NF}')
	echo "current time: $(date -d @${cur_timestamp})" >> ${FILE_LOG}
	# 判断当前时间距离升级时间是否大于等于15天，是，则删除回滚文件
    local time_difference=$(($((${cur_timestamp}-${upgrade_timestamp}))/86400))
	echo "time_difference: ${time_difference}" >> ${FILE_LOG}
	if [[ ${time_difference} -ge 15 ]];then
	    echo "start to delete dir" >> ${FILE_LOG}
		rm -rf /opt/insight_upgrade
        rm -rf /opt/upgrade_backup
        rm -rf /opt/os_upgrade
        rm -rf /opt/sut
        rm -rf /opt/osbackup
        su - ossadm - c "rm -rf /opt/patch_manager"
        su - sopuser - c "rm -rf /home/sopuser/backup"
        su - sopuser - c "rm -rf /opt/backup_cloudsop_tmp"
        uninstall_delete_server
    else
        echo "Less than 15 days.skip" >> ${FILE_LOG}
	fi
    return 0
}

main()
{
    logger  -p local0.info "user: `who -m | cut -d\( -f2 |cut -d\) -f1`, begin to execute ${SCRIPT_NAME},$1"
    if [[ "$1" == "install" ]]; then
        install_delete_server
        logger  -p local0.info "user: `who -m | cut -d\( -f2 |cut -d\) -f1`, execute ${SCRIPT_NAME}, result is $?"
    elif [[ "$1" == "uninstall" ]]; then
        uninstall_delete_server
        logger  -p local0.info "user: `who -m | cut -d\( -f2 |cut -d\) -f1`, execute ${SCRIPT_NAME}, result is $?"
     elif [[ "$1" == "run" ]]; then
        run_delete_server
        logger  -p local0.info "user: `who -m | cut -d\( -f2 |cut -d\) -f1`, execute ${SCRIPT_NAME}, result is $?"
    else
        logger  -p local0.info "user: `who -m | cut -d\( -f2 |cut -d\) -f1`, execute ${SCRIPT_NAME}, parameter error"
    fi
}

main "$@"