#!/bin/bash

CURRENT_PATH="$(cd $(dirname $0);pwd)"
# 日志文件路径
LOGFILE=/var/log/insight/install/install.log
# silent.properties配置
SILENT_CONF=${CURRENT_PATH}/../conf/silent.properties
FI_LOG_IP_FILE="/opt/huawei/Bigdata/om-server/om/inst/conf/oms-config.ini"
#*************************************************************#
# Name:        getSysTime                                     #
# Description: get the system time                            #
# Inout:                                                      #
# Ouput:   Time: 2009-11-03 09:09:09                          #
# Date:    2009-11-03                                         #
#*************************************************************#
function fn_getSysTime()
{
    DST=`/usr/bin/python -c "import time;timest = time.localtime();print(timest.tm_isdst)"`
    if [ $DST == '1' ]
    then
        date "+%Y-%m-%d %T DST"
    else
        date "+%Y-%m-%d %T"
    fi
}
################################################################################
# Function: check_ip
# Description: 校验ip
# Parameter:
#   input:
#   N/A
#   output:
#   N/A
# Return: 0 -- success; not 0 -- failure
# Others: N/A
################################################################################
check_ip()
{
    [[ $1 =~ ^([1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([1-9]?[0-9]|1[0-9][0-9]?|2[0-4][0-9]|25[0-5])){3}$ ]]  ||\
    [[ $1 =~ ^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$ ]]
}

check_ipv6()
{
    ipaddr=$1
    matchResult=`echo "$ipaddr" | grep -E "^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$"`
    if [[ "$matchResult" != "$ipaddr" ]];then
        return 1
    fi
    return 0
}
#*************************************************************#
# Name:         LOG                                           #
# Description: record the message into the logfile            #
# Inout:  log message                                         #
# Ouput:                                                      #
# Date:    2009-11-03                                         #
#*************************************************************#
function LOG()
{
    local strTime=`fn_getSysTime`
    local curSize
    local maxSize=1024000
    local maxRecord=3
    local index=2
    local content="$*"

    content=`echo "${content}"`

    if [ -z ${LOGFILE} ]
    then
        echo -e "[${strTime}] ${content}"
    elif [  -f ${LOGFILE} ]
    then
        curSize=`ls -lk ${LOGFILE} | awk -F" " '{print $5}'`
        if [ ${curSize} -ge ${maxSize} ]
        then
            while [ ${index} -gt 0 ]
            do
                if [ -f ${LOGFILE}.${index} ]
                then
                    mv ${LOGFILE}.${index} ${LOGFILE}.`expr ${index} + 1`

                fi
                let index--
            done
            mv ${LOGFILE} ${LOGFILE}.1

            echo >> ${LOGFILE}
        fi
        echo -e  "[${strTime}] ${content}" | tee -a ${LOGFILE}
        sed -i -e "s#[Pp][Aa][Ss][Ss][Ww][Oo][Rr][Dd]#pvalue#g" -e "s#[Pp][Aa][Ss][Ss][Ww][Dd]#pvalue#g" ${LOGFILE}
    else
        mkdir -p `dirname ${LOGFILE}`
        chmod 700 `dirname ${LOGFILE}`
        echo -e "[${strTime}] ${content}" | tee -a ${LOGFILE}
        sed -i -e "s#[Pp][Aa][Ss][Ss][Ww][Oo][Rr][Dd]#pvalue#g" -e "s#[Pp][Aa][Ss][Ss][Ww][Dd]#pvalue#g" ${LOGFILE}
    fi
}

#*************************************************************#
# Name:        WARN                                           #
# Description: record the warning message into the logfile    #
# Inout:  warning message                                     #
# Ouput:                                                      #
# Date:    2009-11-03                                         #
#*************************************************************#
function WARN()
{
    LOG "WARN: $*"
}

#*************************************************************#
# Name:        ERROR                                          #
# Description: record the error message into the logfile      #
# Inout:  error message                                       #
# Ouput:                                                      #
# Date:    2009-11-03                                         #
#*************************************************************#
function ERROR()
{
    LOG "ERROR: $*"
}

# print log function
function PRINT_LOG()
{
    local LOG_LEVEL=$1
    local LOG_INFO=$2

    if [ -z "${LOGFILE}" ]
    then
        LOGFILE="${THELOGFILE}"
    fi

    case ${LOG_LEVEL} in
        "INFO")
            LOG "${LOG_INFO}"
        ;;
        "WARN")
            WARN "${LOG_INFO}"
        ;;
        "FATAL")
            ERROR "${LOG_INFO}"
        ;;
        "ERROR")
            ERROR "${LOG_INFO}"
        ;;
        *)
            WARN " The LOG_LEVEL must be <INFO|WARN|FATAL>, it will be set to WARN by default ..."
            WARN "${LOG_INFO}"
        ;;
    esac
}

pre_check()
{
    PRINT_LOG INFO "begin to check network connectivity"
    cp ${CUR_PATH}/conf/* ${CUR_PATH}/../conf
    time="$(date "+%Y%m%d%H%M")"
    set_one_param "task_id" "${time}"
    set_one_param "selectedNetType" "start"
    set_one_param "deploy_mode" "start_operate"
    cd ${CUR_PATH}/../script
    ${CUR_PATH}/../script/python/bin/python launch.pyc processor pre.start_stop.pre_check &
    PID="$!"
    wait "$PID"
    if [[ "$?" != "0" ]];then
        PRINT_LOG INFO "check failed"
        logger -p local0.error "$(who -m | cut -d\( -f2 |cut -d\) -f1);execute start.sh failed."
        return 1
    fi
    PRINT_LOG INFO "check success"
    return 0
}


# 检查是否存在已经执行的任务
is_installing(){
    lock_file=$1
    if [[ -f "${lock_file}" ]];then
        pid=$(cat ${lock_file}| grep "pid" | awk -F'=' '{print $2}')
        ps -p ${pid} 2>&1 >/dev/null
        if [[ $? == 0 ]];then
            echo "There is other user running this script, exit."
            logger -p local0.error "$(who -m | cut -d\( -f2 |cut -d\) -f1);there is other user running this script, exit."
            return 1
        fi
    fi
    echo "pid=$$" > ${lock_file}
    if [[ "${lock_file}" == "/tmp/start_all.lock" ]];then
        if [[ -f '/tmp/stop_all.lock' ]];then
            pid=$(cat '/tmp/stop_all.lock'| grep "pid" | awk -F'=' '{print $2}')
            ps -p ${pid} 2>&1 >/dev/null
            if [[ $? == 0 ]];then
                echo "There is other user running stop cluster, exit."
                logger -p local0.error "$(who -m | cut -d\( -f2 |cut -d\) -f1);there is other user running stop cluster, exit."
                return 1
            fi
        fi
    fi
    if [[ "${lock_file}" == "/tmp/stop_all.lock" ]];then
        if [[ -f '/tmp/start_all.lock' ]];then
            pid=$(cat '/tmp/start_all.lock'| grep "pid" | awk -F'=' '{print $2}')
            ps -p ${pid} 2>&1 >/dev/null
            if [[ $? == 0 ]];then
                echo "There is other user running start cluster, exit."
                logger -p local0.error "$(who -m | cut -d\( -f2 |cut -d\) -f1);there is other user running start cluster, exit."
                return 1
            fi
        fi
    fi
    return 0
}


set_one_param(){
    arg_name=$1
    arg_value=$2

    # 如果参数已经存在，先删除，再配置，已新的值为准
    touch ${SILENT_CONF}
    res=$(cat ${SILENT_CONF} | grep ${arg_name})
    if [[ x"${res}" != x ]];then
        sed -i "/$arg_name/d" ${SILENT_CONF}
    fi
    echo "${arg_name}=${arg_value}" >>${SILENT_CONF}
}

check_installed()
{
    PRINT_LOG INFO "begin to check product installed"
    ls -l /opt/oss/manager/etc/sysconf/nodelists.json > /dev/null 2>&1
    if [[ $? != 0 ]];then
        PRINT_LOG ERROR "product not installed, check failed"
        exit 1
    fi
    return 0
}