#!/bin/bash
function main() {
    local urflag=rollback
    local log_path="/opt/oss/NCEEngr/tmp/lock_log"
    [ ! -d "${log_path}" ] && mkdir -p "${log_path}"
    mpid=$$
    CURRENT_DIR=$(cd `dirname "$0"` ;pwd)
    flagName="${log_path}"/post_${urflag}_lock_skip.flag
    if [[ -f ${flagName} ]]
    then
        echo [$(date +'%Y-%m-%d %H:%M:%S')] ${shellName}_${flagName} >> "${log_path}"/post_${urflag}_skip.log
        exit 0
    fi
    lockName=/usr/lib/systemd/system/lock.service
    if [[ ! -f ${lockName} ]]
    then
        echo [$(date +'%Y-%m-%d %H:%M:%S')] ${shellName}_${lockName} >> "${log_path}"/post_${urflag}_skip.log
        exit 0
    fi
    touch ${flagName}
    
    logfilePath="${log_path}"/post_${urflag}_icmr_${mpid}.log
    echo "[$(date +'%Y-%m-%d %H:%M:%S')] Begin !" > ${logfilePath}
    
    LOCALIP=""
    LOCALIP=$(. /opt/oss/manager/bin/engr_profile.sh;python -c "from util import common;print(common.getLocalIP())" 2> /dev/null)
    if [[ -z ${LOCALIP} ]]
    then
        LOCALIP=$(. /opt/oss/manager/bin/engr_profile.sh;python -c "from util import common;print(common.get_local_ip())" 2> /dev/null)
    fi
    echo "LOCALIP=${LOCALIP}" >> ${logfilePath}
    OMPLIST=$(cat /opt/oss/manager/var/agent/managerip.conf | grep "^managerip" | awk -F= '{print $NF}' | sed 's/,/\n/g' | grep -v "^${LOCALIP}$")
    
    randomNum=$(date +%s%N)
    tmpPath="${log_path}/post_${urflag}_${randomNum}"
    mkdir -p ${tmpPath}
    chmod 700 "${tmpPath}"
    cd /opt/oss/manager/tools/resmgr
    ./queryproduct.sh -pn all -output ${tmpPath}
    PRODUCTNAME=($(cat "${tmpPath}"/product_*.json | sed -e 's/,/\n/g' | sed -e 's/}/\n/g' | grep "productname" | awk -F ":" '{print $2}' | awk -F '"' '{print $2}'))
    for product in "${PRODUCTNAME[@]}"
    do
        tmpnode=$(cat "${tmpPath}/nodes_${product}".json | sed 's/,/\n/g'| grep nodemgrip | awk -F\" '{print $4}' | grep -v "^${LOCALIP}$")
        [ -z "${NODELIST}" ] && NODELIST="${tmpnode}" || NODELIST="${NODELIST} ${tmpnode}"
    done
    
    
    echo "OMPLIST=${OMPLIST}" >> ${logfilePath}
    echo "OTHERLIST=${NODELIST}" >> ${logfilePath}
    NODELIST="${OMPLIST} ${NODELIST}"
    echo "NODELIST=${NODELIST}" >> ${logfilePath}
    
    wclfile="${log_path}"/post_${urflag}_wclfile_${mpid}.lst
    if [[ -f ${wclfile} ]]
    then
        rm ${wclfile}
    else
        touch ${wclfile}
    fi
    {        
        sudo /etc/lock/run/sdlock.sh lock
    }&
    for tmp_node in ${NODELIST}
    do
        {
            bash /opt/oss/manager/apps/UniEPAgent/tools/patchmgr/common/sshcli.sh  -u ossadm -timeout 25 -ip ${tmp_node} -cmd "nohup sudo /etc/lock/run/sdlock.sh lock &"
            echo "$tmp_node : $?" >> ${wclfile}
        }&
    done
    wait
    #
    REMOTE_PROCESS_RESULT_FILE=/etc/lock/sdlock.log
    resultLog="${log_path}"/post_${urflag}_monitor_${mpid}.log
    echo "" > ${resultLog}
    OKOK=OKOK
    for tmp_node in ${NODELIST}
    do
        {
            local count=0
            while true
            do
                sleep 1
                echo "${tmp_node} 000 count=${count}" >> ${resultLog}
                result=$(bash /opt/oss/manager/apps/UniEPAgent/tools/patchmgr/common/sshcli.sh -u ossadm -timeout 25 -ip ${tmp_node} -cmd "egrep \"success\" ${REMOTE_PROCESS_RESULT_FILE}") &>> ${resultLog}
                echo "${tmp_node} 111 count=${count}" >> ${resultLog}
                if [ ${count} -eq 15 ]
                then
                    echo "${tmp_node} Fail count=${count}" >> ${resultLog}
                    break
                fi
                if [ -n "${result}" ]
                then
                    echo "${tmp_node} ${OKOK} count=${count}" >> ${resultLog}
                    break
                fi
                let count++
            done
        }&
    done
    wait
    num=$(cat ${resultLog} | grep ${OKOK} | wc -l)
    numNodeList=$(cat ${wclfile} | wc -l)
    echo "[$(date +'%Y-%m-%d %H:%M:%S')] end !" >> ${logfilePath}
    if [[ ${num} != ${numNodeList} ]]
    then
        echo "Error: num=${num}; numNodeList=${numNodeList}" >> ${resultLog}
        rm ${flagName}
        return 5
    fi
    rm ${flagName}
    return 0
}

main $@
exit $?

