#!/bin/bash

# NCE DBAgent BIN目录路径
DBAGENT_BIN_FOLDER="/opt/oss/manager/apps/DBAgent/bin"
# 数据库实例名称前缀-数据库名称MAP
declare -A MY_DATABASE_MAP=(["trustcenterdbsvr"]="trustattestationservicedb" ["zerotrustenginedbsvr"]="zerotrustassessengineservicedb" ["soarservicedbsvr"]="HISI_SOAR_RDB")
# 数据库实例编号-数据库名称MAP，遍历该MAP编排数据库不可见
declare -A REAL_DATABASE_MAP
# 当前脚本名称
SCRIPT_NAME=`basename $0`
# 升级日志目录
LOG_FILE="/opt/oss/log/manager/easysuite_upgrade/${SCRIPT_NAME}.log"

# 日志记录
function log(){
  local msg=$1
  echo "[$(date +'%Y-%m-%d %H:%M:%S')] $msg" |tee -a $LOG_FILE
}

# 校验入参
function check_input(){
  if [ "${1}" == "-input" -a -n "${2}" ]
  then
    INPUT_PATH=${2}
  else
    log "ERROR The input param is invalid."
    exit 0
  fi
}

# 检查版本
function check_version(){
  src_version=`cat ${INPUT_PATH}/plandata.json | grep src_version | tr '"' ' ' | awk '{print $3 }'`
  is_R22C10=`echo ${src_version} | grep R022C10`
  is_R22C00=`echo ${src_version} | grep R022C00`
  if [ -z "${is_R22C10}" ] && [ -z "${is_R22C00}" ]
  then
    log "${src_version} is not R22C10 or R22C00"
    exit 0
  fi
}

# 检查DBAgent BIN目录路径
function check_agent_dir(){
  if [ ! -d "$DBAGENT_BIN_FOLDER" ]
  then
    log "DBAgent bin directory is not exists"
    exit 1
  fi
}

# 填充REAL_DATABASE_MAP
function fill_real_database_map(){
  cd "$DBAGENT_BIN_FOLDER"
  for key in ${!MY_DATABASE_MAP[@]};do
    log "start to query $key instance id...."

    db_instance_id=`./dbsvc_adm -cmd query-db-instance |grep "$key*" | head -n 1 | awk -F " " '{print $1}'`

    if [ "$?" -eq "0" ]
    then
          if [ -z "$db_instance_id" ]
          then
            log "$key instance id is not exists"
          else
            log "query $key instance id $db_instance_id success...."
            REAL_DATABASE_MAP["$db_instance_id"]="${MY_DATABASE_MAP[$key]}"
          fi
    else
          log "query $key instance id failed...."
          exit 1
    fi
  done
}

# 遍历编排数据库不可见
function set_database_unvisible(){
  for key in ${!REAL_DATABASE_MAP[@]};do
    log "start to set $key ${REAL_DATABASE_MAP[$key]} unvisible...."

    ./dbsvc_adm -cmd set-database-status -instid "$key" -dbnames "${REAL_DATABASE_MAP[$key]}" -visible false

    if [ "$?" -eq "0" ]
    then
          log "set $key ${REAL_DATABASE_MAP[$key]} unvisible success...."
    else
          log "set $key ${REAL_DATABASE_MAP[$key]} unvisible failed...."
          exit 1
    fi
  done
}

check_input "$@"
check_version
check_agent_dir
fill_real_database_map
set_database_unvisible

exit 0

