#!/bin/bash

# 脚本工作路径
SCRIPT_PATH=$(cd $(dirname $0);pwd)

# 脚本名称
SELF_FILE=$(basename $0)

# 脚本日志路径
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog/"

#脚本日志文件
LOG_FILE="${LOG_PATH}/${SELF_FILE}.log"

# 配置工作目录
WORK_PATH="/opt/upgrade/easysuite_upgrade/workpath/"

# 产品名 plandata.json productnam
PRODUCT_NAME=""

# 升级路径 plandata.json src_version-des_version
UPGRADE_PATH=""

# WORK_PATH/UPGRADE_PATH/workpath-PRODUCT_NAME/
CONFIG_PATH=""

# INPUT文件路径  plandata.json
INPUT_FILE="${2}/plandata.json"

# 脚本临时工作路径
TMP_PATH="/opt/oss/log/manager/easysuite_upgrade_config/01_post_upgrade_dfs_woodpecker_config_$(date '+%s')"

# common.sh脚本目录
COMMON_SCRIPT_PATH=$(realpath "${SCRIPT_PATH}/../../common/NCE-Common")

##########################################
#  修改 woodpecker_global_sample_rate 字段
##########################################
function modify_woodpecker_global_sample_rate()
{
    file_path="${1}"
    python <<END
import json
with open('${file_path}', 'r', encoding='utf-8') as r_stream:
    file_data = json.load(r_stream)
    with open('${file_path}', 'w', encoding='utf-8') as w_stream:
        file_data.get('productext', {}).update({'woodpecker_global_sample_rate': '1'})
        json.dump(file_data, w_stream)
END
    return 0
}

##########################################
#  判断 NCE产品
##########################################
function check_nce_product()
{
    file_path="${1}"
    python <<END
import json
with open('${file_path}', 'r', encoding='utf-8') as r_stream:
    products_json = json.load(r_stream)
    producttype = products_json.get('producttype', '')
    productsubtype = products_json.get('productext', {}).get('productsubtype', '')
    if 'NCE' in producttype or 'NCE' in productsubtype:
        print('true')
    else:
        print('false')
END
}

##########################################
#  更新全局采样率字段
##########################################
function fresh_woodpecker_global_sample_rate()
{
    # 创建临时工作目录
    mkdir -p ${TMP_PATH}

    # 查询 product_NCE.json
    query_product "${TMP_PATH}" "${PRODUCT_NAME}" || return 1
    
    # 判断产品信息
    is_nce_product=$(check_nce_product "${TMP_PATH}/product_${PRODUCT_NAME}.json")
    if [ "${is_nce_product}" == "false" ]
    then
        LOG_PRINT "INFO" "Not NCE product, ${SELF_FILE} exit."
        rm -rf ${TMP_PATH}
        return 0
    fi

    # 修改 product_NCE.json
    modify_woodpecker_global_sample_rate "${TMP_PATH}/product_${PRODUCT_NAME}.json" || return 1

    # 更新 product_NCE.json
    modify_product "${TMP_PATH}/product_${PRODUCT_NAME}.json" || return 1

    # 退出清理临时目录
    rm -rf ${TMP_PATH}
}

##########################################
#  主入口
##########################################
function main()
{
    # 加载公共模块
    source ${COMMON_SCRIPT_PATH}/common.sh

    # 检查执行用户
    check_ossadm_user || return 1

    # 初始化参数
    initial_params "${INPUT_FILE}" || return 1

    # 加载平台环境变量
    source /opt/oss/manager/bin/engr_profile.sh

    # 更新全局采样率字段
    fresh_woodpecker_global_sample_rate || return 1

    # 默认退出 0
    return 0
}

main "$@"
exit 0