#!/bin/bash
###############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# File name: post_upgrade_refresh_aide_db_and_recover_auidt_rules.sh
# Description: 1、刷新aide数据库；2、恢复audit审计规则
###############################################################################

WORKPATH=$(dirname $(readlink -f "$0"))
SCRIPT_NAME=$(basename $0)
LOG_FILE="/opt/oss/log/manager/easysuite_upgrade/${SCRIPT_NAME}.log"
SSH_PARA="-o ConnectTimeout=30 -o stricthostkeychecking=no -o ConnectionAttempts=5 -o ServerAliveInterval=3 -o ServerAliveCountMax=20"

GET_NODE_ID_PY="${WORKPATH}/get_all_node_ip.py"
[ ! -f "${GET_NODE_ID_PY}" ] && GET_NODE_ID_PY="${WORKPATH}/get_all_node_ip.pyc"


##################################################
# Description: 校验脚本执行用户
# Parameters: null
##################################################
function check_user() {
    if [ "$(whoami)" != "ossadm" ]
    then
        print_log "INFO" "Only the ossadm user can run this script."
        return 1
    fi
}

##################################################
# Description: 日志函数
# @Param1: 日志级别
# @Param2: 日志信息
##################################################
function print_log() {
    echo -e "$(date +%Y-%m-%d) $(date +%H:%M:%S) | ${1} | ${2}" | tee -a ${LOG_FILE}
}

##################################################################################
# Description： sftp传包到其他节点
# @Param:  $1:服务端节点IP
#          $2:待上传包的全路径
#          $3:目标目录
##################################################################################
function sftp_put(){
    if [[ $# != 3 ]]
    then
        print_log "ERROR" "para number is unvalid"
        return 1
    fi
    local node_ip="$1"
    local o_package_path="$2"
    local r_package_path="$3"
    if [[ -z ${o_package_path} ]]
    then
        print_log "ERROR" "o_package_path=(${o_package_path}) is not exist!"
        return 1
    fi
    scp ${SSH_PARA} ${o_package_path} [${node_ip}]:${r_package_path} &>> "${LOG_FILE}"
    local sftp_put_result_return=$?
    local count=0
    while [ "${sftp_put_result_return}" -ne 0 ]
    do
        if [ "${count}" == "4" ]
        then
            print_log "ERROR" "scp ${o_package_path} to [${node_ip}]:${r_package_path} failed"
            break
        fi
        sleep 5
        scp ${SSH_PARA} ${o_package_path} [${node_ip}]:${r_package_path} &>> "${LOG_FILE}"
        sftp_put_result_return=$?
        let count++
    done
    return ${sftp_put_result_return}
}

##################################################################################
# Description： ssh连接到其他节点执行命令
# @Param:  $1:服务端节点IP
#          $2:远程调用命令
##################################################################################
function ssh_sync(){
    if [[ $# != 2 ]]
    then
        print_log "ERROR" "para number is unvalid"
        return 1
    fi
    local node_ip="$1"
    local cmd="$2"
    echo "execute cmd: ssh ${SSH_PARA} ${node_ip} ${cmd}" &>> "${LOG_FILE}"
    ssh ${SSH_PARA} "${node_ip}" "${cmd}" &>> "${LOG_FILE}"
    local ssh_sync_result_return=$?
    local count=1
    while [ "${ssh_sync_result_return}" -eq 255 ]
    do
        if [ ${count} -gt 3 ]
        then
            break
        fi
        sleep $[2**${count}]
        ssh ${SSH_PARA} "${node_ip}" "${cmd}" &>> "${LOG_FILE}"
        ssh_sync_result_return=$?
        let count++
    done
    echo "${ssh_sync_result}" &>> "${LOG_FILE}"
    return ${ssh_sync_result_return}
}

##################################################################################
# Description：连接到其他节点执行提权包
##################################################################################
function execute_task(){
    . /opt/oss/manager/bin/engr_profile.sh
    local pkg_name="common_es_sudobin_pkg.tar"
    local pkg_path="${WORKPATH}/sudo_pkg"
    local upload_path="/tmp"
    local target_shell="refresh_aide_db_and_recover_auidt_rules.sh"
    # 查询所有节点ID
    ID_LIST=$(python "${GET_NODE_ID_PY}") || return $?
    for ip in ${ID_LIST}
    do
        # 传包
        sftp_put "${ip}" "${pkg_path}/${pkg_name}" "${upload_path}" || return 1
        # 到节点执行提权脚本
        local randomNum=$(date +%s%N)
        ssh_sync "${ip}" "sudo ${SUPER_ROOT}/execute.sh ${upload_path}/${pkg_name} /opt/post_upgrade_task_${randomNum} ${target_shell}" &>> "${LOG_FILE}"
        if [ $? -ne 0 ]
        then
            print_log "ERROR" "Failed to execute cmd:sudo ${SUPER_ROOT}/execute.sh ${upload_path}/${pkg_name} /opt/post_upgrade_task_${randomNum} ${target_shell}"
            return 1
        fi
    done
}

function main() {
    check_user || return $?
    execute_task || return $?
}
main
exit $?
