# encoding=utf-8

import pyzenith
import sys
import json
from util import ossext


def main(argv):
    container_path = str(argv[1])
    inst_number = str(argv[2])
    db_list = str(argv[3])
    db_name = str(argv[4])
    db_user_passwd = str(argv[5])
    gaussdb_ip = str(argv[6])
    read_port = str(argv[7])
    sql =  str(argv[8])
    with open(container_path, "r") as fob:
        file_dict = json.load(fob)
        passwd = file_dict[inst_number][db_list][db_name][db_user_passwd]
    if len(passwd) == 0:
        return 1
    passwd = ossext.Cipher.decrypt(passwd)
    if len(passwd) == 0:
        return 2
    conn = pyzenith.connect(gaussdb_ip, db_name, passwd, port=read_port)
    conn.autocommit(True)
    cursor = conn.cursor()
    cursor.execute(sql)
    result = cursor.fetchall()
    cursor.close()
    conn.close()
    print(result)
    return 0


if __name__ == '__main__':
    main(sys.argv)
