#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# -*- coding: utf-8 -*-
"""检查客户自备SUSE系统的组件"""
import os
from .common_utils.check_util import CheckOSInfoUtils
from .common_utils.check_task import OSCheckTask, OSCheckConfig
from .common_utils.check_exception import NoInvolvedSuseOSError

_config_params = {
    # 检查项名称
    "task_name": 'task_check_os_components',
    "upload_src_path": os.path.split(os.path.realpath(__file__))[0],
}


def execute_task_check(kvs):
    """
    执行检查任务
    :param kvs: 全局字典
    :return: bool 检查项是否通过
    """
    task = OSCheckTask(OSCheckConfig(_config_params), kvs)
    if not (task.check_customer_suse_os_type() and task.check_env_rpm()):
        return False
    task.finish()
    return True


def check(kvs):
    """
    功能描述：判断此任务是否需要执行
    :param kvs: 全局字典
    :return: bool 检查结果
    """
    try:
        os_type = CheckOSInfoUtils.get_suse_os_type(kvs)
    except NoInvolvedSuseOSError as e:
        return False
    return "suse-12sp5" in os_type


def exe(kvs):
    """
    功能描述：任务执行入口
    :param kvs: 全局字典
    :return: list 检查结果
    """
    return [[('', '', execute_task_check(kvs))]]
