# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# -*- coding: utf-8 -*-
"""
检查项异常类
"""


class CheckException(Exception):
    """检查项特定异常类"""

    def __init__(self, message):
        super().__init__(message)
        self.message = message

    def __str__(self):
        return self.message


class CmdExecutionError(CheckException):
    """命令执行异常"""
    pass


class CheckResultError(CheckException):
    """检查脚本运行结果失败异常"""
    pass


class InconsistentOSTypeError(CheckException):
    """节点操作系统类型异常"""
    pass


class InvalidOSTypeError(CheckException):
    """节点操作系统类型异常"""
    pass


class NoInvolvedSuseOSError(CheckException):
    """非涉及Suse系统异常"""
    pass


class InvalidOSKernelError(CheckException):
    """节点操作系统内核异常"""
    pass


class UploadFileError(CheckException):
    """上传文件异常"""
    pass


class InconsistentRPMList(CheckException):
    """环境RPM不一致异常"""
    pass


class InvalidRPMVersion(CheckException):
    """环境RPM包版本异常"""
    pass


class InvalidPatchError(CheckException):
    """补丁包异常"""
    pass

