# -*- coding: utf-8 -*-

#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import shlex

import subprocess

EXCEPTION_CODE = -1


def exec_local_cmd(cmd, timeout=360) -> (int, str, str):
    """
    执行shell命令
    :param cmd:待执行的命令（带参数），可执行带管道的命令，需要注意的是，管道内的命令不要包含“|”字符，否则执行会报错
    :param timeout:执行超时时间
    :return: tuple: result, stdout, stderr
    """
    cmd_list = cmd.split("|")
    stream = ""
    try:
        for cmd in cmd_list:
            if not stream:
                stream = subprocess.Popen(shlex.split(cmd), stdin=subprocess.PIPE, stdout=subprocess.PIPE,
                                          stderr=subprocess.PIPE, shell=False, universal_newlines=True)
            else:
                stream = subprocess.Popen(shlex.split(cmd), stdin=stream.stdout, stdout=subprocess.PIPE,
                                          stderr=subprocess.PIPE, shell=False, universal_newlines=True)
        stdout, stderr = stream.communicate(timeout=timeout)
        return stream.returncode, stdout, stderr
    except Exception as e:
        return EXCEPTION_CODE, f"Catch an exception: {e}", ""
