# -*- coding:utf-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
import time
import types
from functools import wraps

# 是否需要重试，底层接口统一重试，上层调用如果已经有重试，则传递下层接口不需要重试
IS_RETRY = "is_retry"


def retry(times=3, interval=3, success_condition: types.FunctionType = lambda _: _):
    """
    重试装饰器
    :param times: 重试次数
    :param interval: 重试间隔：秒
    :param success_condition: 判断成功条件
    :return: func result
    """

    def decorator(func):
        @wraps(func)
        def wrap(*args, **kwargs):
            result = None
            for _ in range(times):
                result = func(*args, **kwargs)
                if success_condition(result) or not kwargs.get(IS_RETRY, True):
                    return result
                time.sleep(interval)
            return result

        return wrap

    return decorator
