# -*- coding: utf-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

from constant.constant import RetCode
from service.service import Service


class FCService(Service):
    """ FC健康检查 """

    def __init__(self, service_info):
        super().__init__(service_info)

    def check_connect_cmd(self):
        return "ls"

    def get_service_alarm_forward_param(self):
        """ FC无法获取到snmp信息 """
        pass

    def build_check_function_list(self) -> list:
        """ 生成check list，列表内容为(func, RetCode)"""
        return [
            (self.check_local_alarm_ip_ping_to_service_ip, RetCode.PING_ERROR),
            (self.check_connect, RetCode.CONNECT_ERROR),
            (self.check_alarm_receive_param_exist, RetCode.ALARM_RECEIVE_PARAM_NOT_EXIST_ERROR)
        ]
