#!/bin/bash
#
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
#

ACTION=$1
SCRIPT_PATH=
CHECK_SCRIPT=


#############################################
# 初始化全局变量
#############################################
function init() {
    SCRIPT_PATH=$(dirname $(readlink -f $0))
    CHECK_SCRIPT="${SCRIPT_PATH}/check_hardware_alarm_main.py"
    GET_HARDWARE_IP_SCRIPT="${SCRIPT_PATH}/get_hardware_ip.py"
}

function main() {
    init
    source /opt/oss/manager/bin/engr_profile.sh > /dev/null 2>&1
    case ${ACTION} in
        'get_hardware_ip')
            python "${GET_HARDWARE_IP_SCRIPT}"
            return $?
        ;;
        'check')
            python "${CHECK_SCRIPT}"
            return $?
        ;;
    esac
}

#############################################
# 仅允许ossadm用户调用
#############################################
[ "$(whoami)" == "ossadm" ] && {
    main "$@"
    exit $?
}
echo "Only the ossadm user can run this script."
exit 1
