#!/bin/bash
#####################################################################################
#
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
#
# Description: 执行远程ssh命令，适用服务器、交换机、FusionCompute
#
# Usage： bash ssh_cmd.sh <IP> <USERNAME> <CMD_TYPE> <CMD>
#
# Output: 执行结果
#
#####################################################################################


IP=$1
USERNAME=$2
CMD_TYPE=$3
CMD=$4
read -sr PWD
PWD=$(echo ${PWD} | sed 's/\\/\\\\/g' | sed 's/}/\\}/g' | sed 's/{/\\{/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')

# 超时退出
RETURN_TIMEOUT=201
# 连接失败
RETURN_CONNECT_FAILED=202
# 连接拒绝
RETURN_CONNECTION_REFUSED=203
# 连接无权限
RETURN_CONNECT_PERMISSION_DENIED=204
# 成功退出
RETURN_SUCCESS_CODE=0
# expect脚本识别标识
EXPECT_FLAG="*>"
TYPE_SERVER="service"
TYPE_SWITCH="switchService"
TYPE_FC="fcService"
# 超时时间
TIMEOUT=20


##################################################
# 前置操作：根据命令类型，确认expect命令下发成功标识
##################################################
function prepare_operation() {
    [ "${CMD_TYPE}" == "${TYPE_SERVER}" ] && EXPECT_FLAG="*>"
    [ "${CMD_TYPE}" == "${TYPE_SWITCH}" ] && EXPECT_FLAG="<*>"
    [ "${CMD_TYPE}" == "${TYPE_FC}" ] && EXPECT_FLAG="*@*"
}


##################################################
# expect命令远程执行命令
##################################################
function exec_cmd() {
    expect_output=$(expect << ENF
    set timeout ${TIMEOUT}
    spawn ssh -o StrictHostKeyChecking=no ${USERNAME}@${IP}
    expect {
        "*No route to host*" { exit ${RETURN_CONNECT_FAILED} }
        "*Name or service not known*" { exit ${RETURN_CONNECT_FAILED} }
        "*Connection refused*" { exit ${RETURN_CONNECTION_REFUSED} }
        "*Permission denied*" { exit ${RETURN_CONNECT_PERMISSION_DENIED} }
        "*Name or service not known*" { exit ${RETURN_CONNECT_FAILED} }
        "*Connection reset*" { exit ${RETURN_CONNECT_PERMISSION_DENIED} }
        "*assword:" { send -- "${PWD}\r" }
    }
    # 交换机上执行shell命令，需要临时关闭显示行数
    if { "${CMD_TYPE}" == "${TYPE_SWITCH}" } {
        expect {
            "${EXPECT_FLAG}" { send "screen-length 0 temporary\r" }
            timeout { exit ${RETURN_TIMEOUT} }
        }
    }
    expect {
        "${EXPECT_FLAG}" { send "${CMD}\r" }
        timeout { exit ${RETURN_TIMEOUT} }
    }
    expect {
        "${EXPECT_FLAG}" { exit ${RETURN_SUCCESS_CODE} }
    }
    expect timeout { exit ${RETURN_TIMEOUT} }
    expect eof
ENF
)
    return_code=$?
    echo "${expect_output}"
    return ${return_code}
}


##################################################
# 入口方法
##################################################
function main() {
    # 清理known_host
    sed -i "/\<${IP}\>/d" /home/ossadm/.ssh/known_hosts
    # 前置操作
    prepare_operation
    # 执行远程expect命令
    exec_cmd
    return $?
}

#############################################
# 仅允许ossadm用户调用
#############################################
[ "$(whoami)" == "ossadm" ] && {
  main "$@"
  exit $?
}
echo "Only the ossadm user can run this script."
exit 1
