#!/bin/bash
##############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# File name: check_os_configuration.sh
# Description: 操作系统升级准入检查
##############################################################################
# 入口脚本路径
CURRENT_PATH=$(cd $(dirname $0);pwd)
# 检查脚本所在路径
SCRIPT_PATH="${CURRENT_PATH}/scripts"
# 任务列表
CHECK_TASKS_FILE="${SCRIPT_PATH}/check_tasks"
# 结果记录文件
RESULT_FILE="/var/log/check_os_configuration_result"

#########################
# Description: 程序主入口
#########################
function main(){
    [ -f "${RESULT_FILE}" ] && rm -f "${RESULT_FILE}"
    touch "${RESULT_FILE}"
    chmod 644 "${RESULT_FILE}"

    while read line || [[ -n ${line} ]];
    do
        execute_task ${line}
    done <<< "$(cat ${CHECK_TASKS_FILE} | grep -v '^#' | grep -v '^$')"

    return 0
}

#########################
# Description: 执行检查任务
# Param1:   检查项名称
# Param2:   检查脚本
#########################
function execute_task(){
    local task_name="$1"
    local task_script="${SCRIPT_PATH}/${2}"

    [ -f "${task_script}" ] || record_the_check_result "$?" "${task_name}" "The script file :${task_script} is not exist" || return 1
    check_result=$(bash ${task_script})
    record_the_check_result "$?" "${task_name}" "${check_result}" || return 1

    return 0
}

#########################
# Description: 记录检查结果
# Param1:   检查脚本返回值
# Param2:   检查项名称
# Param3:   检查结果
#########################
function record_the_check_result(){
    local return_code="$1"
    local task_name="$2"
    local check_result="$3"
    if [ ${return_code} -eq 0 ];then
        echo "----------------------------------" >> ${RESULT_FILE}
        echo "[${task_name}]: check successfully" >> ${RESULT_FILE}
        echo "----------------------------------" >> ${RESULT_FILE}
    else
        echo "----------------------------------" >> ${RESULT_FILE}
        echo "[${task_name}]: check failed" >> ${RESULT_FILE}
        echo "${check_result}" >> ${RESULT_FILE}
        echo "----------------------------------" >> ${RESULT_FILE}
    fi
    return ${return_code}
}

main
exit $?