#!/bin/bash

##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

##################################################
# 初始化日志路径和日志文件名
##################################################
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"
OSS_USER=$(id -nu 3001)

##################################################
# 校验执行用户
# 脚本要求使用oss用户执行
##################################################
function check_user()
{
    local user
    user=$(whoami)
    if [ "${user}" != "${OSS_USER}" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

##################################################
# 日志记录进task.log
##################################################
function TASK_LOG()
{
    BASH_PID=$$
    if [ "$1" = "ERROR" -o "$1" = "error" ]
    then
        Level="ERROR"
    elif [ "$1" = "WARN" -o "$1" = "warn" ]
    then
        Level="WARN"
    else
        Level="INFO"
    fi
    echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${BASH_PID}] | ${Level} $2" | tee -a ${TASK_LOG_FILE}
}

##################################################
# 初始化变量
##################################################
function init_variable()
{
    TASKID=$1
    SRC_VERSION=$2
    DES_VERSION=$3

    # 初始化Easysuite任务相关日志/进度/状态文件
    TASK_ID_PATH="/opt/upgrade/easysuite_upgrade/taskmgr/${TASKID}"
    TASK_LOG_FILE="${TASK_ID_PATH}/task.log"
    TASK_PROGRESS_FILE="${TASK_ID_PATH}/task.progress"
    TASK_STATUS_FILE="${TASK_ID_PATH}/task.status"

    # 配置仲裁脚本及入参
    ARB_CONFIG_SCRIPT="${OSS_ROOT}/apps/DRService/pyscript/enable_dr_arbitration.py"
    [ -f "${ARB_CONFIG_SCRIPT}" ] || ARB_CONFIG_SCRIPT="${ARB_CONFIG_SCRIPT}c"
    DR_INFO_JSON="/opt/upgrade/backup/${SRC_VERSION}-${DES_VERSION}/drinfo.json"
    DR_HEALTH_CHECK_JSON="/opt/upgrade/backup/${SRC_VERSION}-${DES_VERSION}/dr_health_time.json"

    init_taskmgr ${TASKID}
}

##################################################
# 配置仲裁自动倒换开关
##################################################
function config_arb()
{
    TASK_LOG "INFO" "Start to config arbitration."
    fresh_es_progress ${TASKID} "10"
    python ${ARB_CONFIG_SCRIPT} ${DR_INFO_JSON} ${DR_HEALTH_CHECK_JSON} >>${TASK_LOG_FILE}
    if [ $? -eq 0 ]
    then
        TASK_LOG "INFO" "Finished to config arbitration."
        fresh_es_status ${TASKID} "success"
        fresh_es_progress ${TASKID} "100"
    else
        TASK_LOG "INFO" "Failed to config arbitration."
        fresh_es_status ${TASKID} "fail"
        fresh_es_progress ${TASKID} "100"
    fi
}

##################################################
# 脚本主入口
##################################################
function main()
{
    # 加载公共方法、平台环境变量
    source ${SCRIPT_PATH}/common.sh
    source /opt/oss/manager/bin/engr_profile.sh

    # 检查执行用户
    check_user || return 1

    # 初始化参数
    init_variable "$@"

    # 配置仲裁
    config_arb
}

main "$@"
exit $?