#!/bin/bash
##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

##################################################
# 初始化日志路径和日志文件名
##################################################
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"

##################################################
# 超时配置
##################################################
TIMEOUT_CONFIG="/opt/upgrade/easysuite_upgrade/scripts/common/NCE-Common/envpatch/timeout.ini"
TIMEOUT=$(cat "${TIMEOUT_CONFIG}" | grep -w operate_envpatch_timeout | awk -F "=" '{print $2}')
TIMEOUT_ERROR=124

##################################################
# 平台三方软件包扫描路径
##################################################
PUB_SOFTWARE_PATH="/opt/pub/software/legacyRepo"

##################################################
# 校验执行用户, 使用ossadm执行
##################################################
function check_user()
{
    local user
    user=$(whoami)
    oss_user=$(id -nu 3001)
    if [ "${user}" != "${oss_user}" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

##########################################
# 日志函数
##########################################
function DOUBLE_LOG()
{
    local level=${1}
    local message=${2}
    # 记录日志
    local date_time=$(date '+%Y-%m-%d %H:%M:%S')
    echo "[${date_time}] ${level} | ${message}" | tee -a ${LOG_FILE} -a ${TASK_LOG}
}

##########################################
# 刷新EasySuite任务
##########################################
function fresh_es_task()
{
    local progress="${1}"
    local status="${2}"
    echo Progress=${progress} >${TASK_PROGRESS}
    echo Status=${status} >${TASK_STATUS}
}

##################################################
# 初始化参数
##################################################
function init_params()
{
    # 脚本入参
    TASK_ID=${1}
    UPLOAD_PATH=${2}
    PATCH_NAME=${3}
    ACTION=${4}

    # 补丁包内层包名
    PKG_NAME="${PATCH_NAME//_pkg.tar/}.tar.gz"
    # 任务日志|进度|状态
    TASK_LOG="${TASK_MGR_PATH}/${TASK_ID}/task.log"
    TASK_PROGRESS="${TASK_MGR_PATH}/${TASK_ID}/task.progress"
    TASK_STATUS="${TASK_MGR_PATH}/${TASK_ID}/task.status"

    init_taskmgr "${TASK_ID}"
}

##################################################
# 解压业务虚拟补丁包
##################################################
function unzip_pkg()
{
    # 补丁包扫描路径及解压路径
    pkg_path="${PUB_SOFTWARE_PATH}/${PKG_NAME//.tar.gz/}/${PKG_NAME}"
    unzip_path="${UPLOAD_PATH}/envpatch"

    DOUBLE_LOG "INFO" "Start to unzip ${PKG_NAME}."
    # 创建解压目录
    [ -d ${unzip_path} ] && rm -rf ${unzip_path}
    mkdir -p ${unzip_path}

    # 解压补丁包
    if [ ! -f "${pkg_path}" ]
    then
        DOUBLE_LOG "ERROR" "${PKG_NAME} is not exist in software pub."
        fresh_es_task "10" "fail"
        return 1
    fi
    tar -zvxf "${pkg_path}" -C "${unzip_path}"
}

##################################################
# 升级/回滚业务虚拟补丁
##################################################
function operate_envpatch()
{
    unzip_pkg || return 1

    # 启动安装脚本（默认超时时间10分钟）
    local install_script="${unzip_path}/VRPatch/install_vrpatch.sh"
    DOUBLE_LOG "INFO" "Start to ${ACTION} envpatch."
    timeout ${TIMEOUT} bash ${install_script} ${ACTION} >> ${TASK_LOG}
    result=$?
    if [ ${result} -eq ${TIMEOUT_ERROR} ]
    then
        DOUBLE_LOG "ERROR" "${ACTION} envpatch timeout: ${TIMEOUT} seconds."
        fresh_es_task "100" "fail"
        return 1
    elif [ ${result} -ne 0 ]
    then
        DOUBLE_LOG "ERROR" "Failed to ${ACTION} envpatch."
        fresh_es_task "100" "fail"
        return 1
    fi
    DOUBLE_LOG "INFO" "Finish to ${ACTION} envpatch."
    fresh_es_task "100" "Success"
}

##################################################
# 主函数入口
##################################################
function main()
{
    # 校验执行用户
    check_user || return 1

    # 加载EasySuite公共方法
    source ${SCRIPT_PATH}/../common.sh

    # 初始化参数
    init_params "$@"

    # 升级/回滚业务虚拟补丁
    operate_envpatch

    # 清理解压目录
    rm -rf ${unzip_path}
}

main "$@"
exit $?