#!/bin/bash
##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)
LOCK_SCRIPT_PATH="/opt/upgrade/easysuite_upgrade/scripts/NCE-Common/lock_script"

##################################################
# 初始化日志路径和日志文件名
##################################################
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"

##################################################
# 校验执行用户, 使用ossadm执行
##################################################
function check_user()
{
    local user
    user=$(whoami)
    oss_user=$(id -nu 3001)
    if [ "${user}" != "${oss_user}" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

##########################################
# 日志函数
##########################################
function DOUBLE_LOG()
{
    local level=${1}
    local message=${2}
    # 记录日志
    local date_time=$(date '+%Y-%m-%d %H:%M:%S')
    echo "[${date_time}] ${level} | ${message}" | tee -a ${LOG_FILE} -a ${TASK_LOG}
}

##########################################
# 刷新EasySuite任务状态
##########################################
function fresh_es_task()
{
    local progress="${1}"
    local status="${2}"
    echo Progress=${progress} >${TASK_PROGRESS}
    echo Status=${status} >${TASK_STATUS}
}

##################################################
# 初始化参数
##################################################
function init_params()
{
    # 脚本入参
    TASK_ID=${1}
    ACTION=${2}

    # 任务日志|进度|状态
    TASK_LOG="${TASK_MGR_PATH}/${TASK_ID}/task.log"
    TASK_PROGRESS="${TASK_MGR_PATH}/${TASK_ID}/task.progress"
    TASK_STATUS="${TASK_MGR_PATH}/${TASK_ID}/task.status"

    init_taskmgr "${TASK_ID}"
}

##################################################
# lock操作
##################################################
function operate_lock_service()
{
    # 执行lock脚本
    local lock_script="${LOCK_SCRIPT_PATH}/${ACTION}_lock.sh"
    DOUBLE_LOG "INFO" "Start to execute ${lock_script}."
    bash ${lock_script} >> ${TASK_LOG}
    result=$?
    if [ ${result} -ne 0 ]
    then
        DOUBLE_LOG "ERROR" "Failed execute ${lock_script}."
        fresh_es_task "100" "fail"
        return 1
    fi
    DOUBLE_LOG "INFO" "Finish to execute ${lock_script}."
    fresh_es_task "100" "Success"
}

##################################################
# 主函数入口
##################################################
function main()
{
    # 校验执行用户
    check_user || return 1

    # 加载EasySuite公共方法
    source ${SCRIPT_PATH}/common.sh

    # 初始化参数
    init_params "$@"

    # 执行lock脚本
    operate_lock_service
}

main "$@"
exit $?