#!/bin/bash
#检查所有节点上是否存在/opt/signtool目录，不存在则创建（扩容后可能会删除，导致欧方升级失败）
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)
ERROR_CODE_FILE="${SCRIPT_PATH}/config/${SELF_FILE}.json"

function get_all_nodes_ip()
{
    . /opt/oss/manager/bin/engr_profile.sh
    nodes_ip=$(python <<EOF
import os
import json

nodelist_file=os.path.join(os.getenv("INSTALL_ROOT", "/opt/oss"), "manager", "etc", "sysconf", "nodelists.json")
with open(nodelist_file) as f:
    data=json.load(f)

nodes_ip_list = []
for _, node in data['nodeList'].items():
    for ip_info in node['IPAddresses']:
        if 'maintenance' in ip_info['usage']:
            nodes_ip_list.append(ip_info['IP'])
            break

nodes_ip_str = " ".join(nodes_ip_list)
print(nodes_ip_str)
EOF
)
}

function exec_sudo_cmd()
{
    ERROR_PATH=$4

    #加载平台环境变量(获取提权框架SUPER_ROOT环境变量)
    . /opt/oss/manager/bin/engr_profile.sh

    #获取产品名
    product_name=$(grep -Po 'productname[" :]+\K[^"]+'  "${2}"/plandata.json)

    #升级提权包路径
    sudobin_pkg_path="/opt/upgrade/easysuite_upgrade/scripts/common/NCE-Common/upgrade_sudo_pkg/sudobin_pkg.tar"
    if [ ! -f ${sudobin_pkg_path} ]
    then
        echo "upgrade sudobin package is not exist."
        return 1
    fi

    #提权脚本临时路径
    tmp_uuid=$(cat /proc/sys/kernel/random/uuid)
    tmp_sudo_path="/opt/tmp_sudo_${tmp_uuid}"
    echo ${tmp_sudo_path}

    #提权scp路径
    scp_path="/home/ossadm/${product_name}"

    get_all_nodes_ip
    for nodeip in ${nodes_ip}
    do
        ssh -o StrictHostKeyChecking=no ossadm@${nodeip} 'mkdir -p '${scp_path}'' &>>/dev/null
        local ssh_result=$?
        if [ $ssh_result -eq 1 -o $ssh_result -eq 255 ]
        then
            echo "Failed to connect ${nodeip}."
            # 返回2表示节点连接失败
            return 2
        elif [ $ssh_result -ne 0 ]
        then
            echo "mkdir ${scp_path} on node ${nodeip} failed."
            return 1
        fi

        # 只有scp命令区分ipv6
        echo "${nodeip}" | grep -q ":"
        if [ $? -ne 0 ]
        then
            # ipv4
            scp -o StrictHostKeyChecking=no ${sudobin_pkg_path} ossadm@${nodeip}:${scp_path}
        else
            # ipv6
            scp -o StrictHostKeyChecking=no ${sudobin_pkg_path} ossadm@[${nodeip}]:${scp_path}
        fi
        if [ $? -ne 0 ]
        then
            echo "scp sudobin package to node ${nodeip} failed."
            return 1
        fi

        ssh -o StrictHostKeyChecking=no ossadm@${nodeip} 'sudo '${SUPER_ROOT}'/execute.sh '${scp_path}'/sudobin_pkg.tar '$tmp_sudo_path' resolve_previous_version_issues.sh' &>>/dev/null
        local ssh_result=$?
        if [ $ssh_result -eq 1 -o $ssh_result -eq 255 ]
        then
            echo "Failed to connect ${node_ip}."
            # 返回2表示节点连接失败
            return 2
        elif [ $ssh_result -ne 0 ]
        then
            echo "execute resolve_previous_version_issues.sh on node ${nodeip} failed."
            return 1
        fi

        ssh -o StrictHostKeyChecking=no ossadm@${nodeip} 'rm -rf '${scp_path}'' &>>/dev/null
        local ssh_result=$?
        if [ $ssh_result -eq 1 -o $ssh_result -eq 255 ]
        then
            echo "Failed to connect ${node_ip}."
            # 返回2表示节点连接失败
            return 2
        elif [ $ssh_result -ne 0 ]
        then
            echo "clear ${scp_path} on node ${nodeip} failed."
            return 1
        fi
    done
    return 0
}

# 脚本失败生成错误码
function generate_error_code() {
    python <<EOF
import os
import json

with open("${ERROR_CODE_FILE}", "r") as f:
    error_code_details = json.loads(f.read())
error_code_detail = error_code_details.get("${main_result}", {})
error_code_json = os.path.join("${ERROR_PATH}", "${SELF_FILE}.json")
with open(error_code_json, "w") as f:
    f.write(json.dumps(error_code_detail))
EOF
}

exec_sudo_cmd "$@"
main_result=$?
# 生成错误码
[ ${main_result} -ne 0 ] && generate_error_code
exit ${main_result}