# encoding=utf-8
"""
功 能：刷新产品版本号
"""
import sys
import os
import shutil
import json
import time
import subprocess
import uuid

from commonlog import Logger

logger = Logger().getinstance(sys.argv[0])


def modify_product_info(tmp_file, product_file):
    """
    修改产品信息
    :param tmp_file:
    :param product_file:
    :return:
    """
    logger.info(f"[{product_file}] Start to modify product info.")
    cmd = f"bash /opt/oss/manager/tools/resmgr/modifyproductinfo.sh -input {os.path.join(tmp_file, product_file)}"
    exitcode, output = subprocess.getstatusoutput(cmd)
    if exitcode != 0:
        logger.info(f"[{product_file}] Failed to modify product info, exitcode:{exitcode}, output: {output}")
        return False
    logger.info(f"[{product_file}] Finish to modify product info.")
    return True


def query_product_info(tmp_path):
    """
    查询产品信息
    :param tmp_path:
    :return:
    """
    logger.info("Start to query product info.")
    cmd = f"bash /opt/oss/manager/tools/resmgr/queryproduct.sh -pn all -output {tmp_path}"
    exitcode, output = subprocess.getstatusoutput(cmd)
    if exitcode != 0:
        logger.info(f"Failed to query product info, exitcode is:{exitcode}, output is:{output}")
        return False
    logger.info("Finish to query product info.")
    return True


def update_product_config(tmp_path, new_product_version):
    """
    更新产品版本号
    :param tmp_path:
    :param new_product_version:
    :return:
    """
    logger.info(f"new_product_version is {new_product_version}")
    # 查产品信息, 最多重试2次
    query_result = False
    for _ in range(0, 2):
        query_result = query_product_info(tmp_path)
        if query_result:
            break
    if not query_result:
        return False
    # 修改文件权限
    logger.info(f"Start to modifying file permissions.")
    subprocess.getstatusoutput(f"chmod 750 -R {tmp_path}")
    # 修改所有product_*.json中的版本号
    product_file_list = []
    for file in os.listdir(tmp_path):
        if "product" in file and file.endswith('.json'):
            product_file_list.append(file)
            with open(os.path.join(tmp_path, file), 'r', encoding='utf-8') as fjb:
                load_dict = json.load(fjb)
            load_dict["productext"]["product_version"] = new_product_version
            with os.fdopen(os.open(os.path.join(tmp_path, file), os.O_CREAT | os.O_WRONLY | os.O_TRUNC,
                                   mode=0o640), 'a', encoding='utf-8') as w_stream:
                w_stream.write(json.dumps(load_dict))
    # 修改产品信息
    for product_file in product_file_list:
        if not modify_product_info(tmp_path, product_file):
            return False
    return True


def main(argv):
    """
    脚本执行用户为ossadm
    :param argv:
    :return:
    """
    new_product_version = argv[1]
    tmp_path = f"/opt/upgrade/product_info_{str(uuid.uuid4())[:32]}"
    # 删除环境上已存在的tmp_path，可能是目录或者文件
    if os.path.isdir(tmp_path):
        shutil.rmtree(tmp_path, True)
    elif os.path.exists(tmp_path):
        os.remove(tmp_path)
    logger.info(f"Start to create a temporary directory: {tmp_path}")
    os.mkdir(tmp_path)
    result = update_product_config(tmp_path, new_product_version)
    logger.info(f"Start to delete the temporary directory: {tmp_path}")
    shutil.rmtree(tmp_path, True)
    if result:
        return True
    return False


if __name__ == '__main__':
    main(sys.argv)
