# encoding=utf-8
"""
功 能：OS目录操作
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2023-03-23 12:00 创建
"""
import sys
import os
import shutil
import subprocess
import shlex
import json

from commonlog import Logger

LOG = Logger().getinstance(sys.argv[0])


class OsUtils:
    def __init__(self):
        pass

    @staticmethod
    def set_f_acl(file_name, group=None, user=None, permit='r'):
        if group:
            set_permit_cmd = f'setfacl -m g:{group}:{permit} {file_name}'
        elif user:
            set_permit_cmd = f'setfacl -m u:{user}:{permit} {file_name}'
        else:
            return True
        return OsUtils.execute_cmd(set_permit_cmd, timeout=60)

    @staticmethod
    def mkdir(*args, **kwargs):
        """
        功能说明:目录创建
        :return:
        """
        try:
            os.makedirs(*args, **kwargs)
        except Exception as e:
            LOG.warning(f"Failed to create path({args}).Exception:{e}")

    @staticmethod
    def rm(path):
        """
        功能说明:目录清理
        :return:
        """
        try:
            # 路径不存在无需删除
            if os.path.exists(path):
                shutil.rmtree(path)
        except Exception as e:
            LOG.warning(f"Failed to del path({path}).Exception:{e}")

    @staticmethod
    def read_json(file_path):
        """
        功能说明:读取json文件
        :return: dict默认报错详情
        """
        # 文件不存在返回空串记录失败日志
        if not os.path.isfile(file_path):
            LOG.error(f"Parsing error|File({file_path}) is not exists.")
            return dict()

        # 初始化文件内容,报错场景和其他区分
        file_data = "read_json.default"
        try:
            with open(file_path, 'r') as r_stream:
                # 中间读取后再做解析,用于解析异常场景定位问题
                file_data = r_stream.read()
                return json.loads(file_data)
        except Exception as e:
            LOG.error(f"Parsing error|Failed to parase {file_path}.file_data:{file_data}."
                      f"Exception:{e}")
            return dict()

    @staticmethod
    def write_json(file_path, data, mode=0o600):
        """
        功能说明:
        :param file_path:
        :param data:
        :param mode:
        :return:
        """
        with os.fdopen(os.open(file_path,
                               os.O_CREAT | os.O_WRONLY | os.O_TRUNC,
                               mode=mode), "w", encoding="utf-8") as w_stream:
            json.dump(data, w_stream, indent=4)

    @staticmethod
    def execute_cmd(cmd, timeout=3600):
        """
        功能描述：使用subprocess执行命令
        参数： cmd
        返回值: 返回码, 标准输出/标准错误
        """
        try:
            process = subprocess.Popen(shlex.split(cmd), shell=False, encoding='utf-8',
                                       stderr=subprocess.PIPE,
                                       stdout=subprocess.PIPE)
            stdout, stderr = process.communicate(timeout=timeout)
            code = process.returncode
            output = f"{os.linesep}stdout:{stdout}{os.linesep}stderr:{stderr}"
        except Exception as e:
            LOG.warning("execute_cmd.exception:error.cmd:%s" % cmd)
            code = "201"
            output = "execute_cmd.exception"
        return code, output
