# encoding=utf-8
"""
功 能：数据库查询操作和解密数据库密码
版权信息：华为技术有限公司，版本所有(C) 2020-2029
修改记录：2020-06-01 12:00 创建
"""

import os
import sys
import json
import easyhttputil
from util import ossext
from commonlog import Logger

LOGGER = Logger().getinstance(sys.argv[0])


def get_password():
    """
    功能描述：获取数据库密文密码
    返回： 数据库密文密码
    修改记录：新增方法
    """
    db_connect_file = "/opt/oss/manager/var/tenants/manager/containerlist.json"
    with open(db_connect_file, "r") as fob:
        file_dict = json.load(fob)
        for one_key in file_dict:
            if file_dict.get(one_key).get("adminPassword") == "":
                continue
            return file_dict.get(one_key).get("adminPassword")
    LOGGER.error("[get_password] Failed to obtain the database login information.")
    return ""


def get_db_info(group, service, write_file):
    """
    功能描述：获取数据库表信息
    返回： 数据库表信息
    修改记录：新增方法
    """
    # 检查配置文件
    LOGGER.info("[get_db_info] Get db info.")
    oss_root = os.popen("echo $OSS_ROOT").read().strip()
    sys_file_name = "%s/agent/etc/install/default_value.json" % oss_root
    db_file_name = "%s/var/tenants/manager/containerlist.json" % oss_root
    if not os.path.isfile(sys_file_name) or not os.path.isfile(db_file_name):
        LOGGER.error("[get_db_info] The system or database configuration files do not exist.")
        return "The system or database configuration files do not exist."

    # 获取DB用户及密码
    with open(sys_file_name, "r", encoding='utf-8') as open_sys_file:
        json_data = json.load(open_sys_file)
    sys_dbuser_user = json_data.get("users", {}).get("DB", {}).get("name", "")
    if sys_dbuser_user == "":
        LOGGER.error("[get_db_info] Failed to obtain "
                     "the information about the system user dbuser.")
        return "Failed to obtain the information about the system user dbuser."

    # 获取服务DB用户及密码
    access_ip, access_port, admin_password, container_type, db_password = get_db_login_config(
        db_file_name, group, service)
    if container_type == "" or admin_password == "" \
            or access_ip == "" or access_port == "" or db_password == "":
        LOGGER.error("[get_db_info] Failed to obtain the database login information.")
        return "Failed to obtain the database login information."

    # 执行获取数据库表信息
    exec_flag = False
    if container_type == "zenith":
        db_password = ossext.Cipher.decrypt(db_password)
        get_db_info_cmd = "echo \'%s\' | " \
                          "sudo -u %s bash -c '. /home/dbuser/.bashrc;" \
                          "/opt/zenith/app/bin/zsql DRServiceDB@%s:%s " \
                          "-c \"select CONFIG_NAME,CONFIG_VALUE,TIME_STAMP from T_DR_CONFIGURATION;\"' >%s;" \
                          "OSS_USER=$(id -nu 3001);" \
                          "chown ${OSS_USER}:ossgroup %s" % (db_password, sys_dbuser_user, access_ip,
                                                             access_port, write_file, write_file)
        if os.system(get_db_info_cmd) == 0:
            exec_flag = True
    elif container_type == "gauss":
        exec_flag = execute_gauss_sql(access_ip, access_port, admin_password, exec_flag,
                                      write_file)

    if exec_flag is True:
        LOGGER.info("[get_db_info] EXEC_SUCCESS.")
        return "EXEC_SUCCESS"
    LOGGER.error("[get_db_info] Failed to generate the result file.")
    return "Failed to generate the result file."


def get_db_login_config(db_file_name, group, service):
    """
    功能说明:获取数据库登录信息
    :param db_file_name:
    :param group:
    :param service:
    :return:
    """
    nce_param_file = "/opt/upgrade/easysuite_upgrade/scripts/common/NCE-Common/nce_params_secure.json"
    with open(nce_param_file, "r", encoding='utf-8') as nce_param:
        nce_param_data = json.load(nce_param)
    exportParam = nce_param_data.get("exportParam", "")
    if not exportParam:
        return "", "", "", "", ""
    if hasattr(easyhttputil, 'httppostWithRetry'):
        http_post_func = easyhttputil.httppostWithRetry
    else:
        http_post_func = easyhttputil.http_post_with_retry
    response = http_post_func('/rest/plat/deploy-proxy/v1/containerlist/action?action-id=export-containerlist',
                              exportParam, retry=3,
                              sleep=5)
    json_data = json.loads(response.decode('utf-8'))
    for k in json_data.keys():
        group_data = json_data.get(k, {})
        if k.startswith(group):
            container_type = group_data.get("containerType", "")
            admin_password = group_data.get("adminPassword", "")
            access_ip = group_data.get("ip", "")
            access_port = group_data.get("port", "")
            db_password = group_data.get("dbList", {}).get(service, {}).get("dbUserPasswd", "")
            if container_type == "" or admin_password == "" \
                    or access_ip == "" or access_port == "" or db_password == "":
                continue
            break
    return access_ip, access_port, admin_password, container_type, db_password


def execute_gauss_sql(access_ip, access_port, admin_password, exec_flag, write_file):
    import gsdb
    admin_password = ossext.Cipher.decrypt(admin_password)
    conn = gsdb.connect(access_ip, 'dbuser', admin_password,
                        'drservicedb', port=int(access_port))
    cursor = conn.cursor()
    cursor.execute("select CONFIG_NAME,CONFIG_VALUE,TIME_STAMP from T_DR_CONFIGURATION;")
    result = cursor.fetchall()
    with os.fdopen(os.open(write_file,
                           os.O_CREAT | os.O_WRONLY | os.O_TRUNC,
                           mode=0o660), "w", encoding="utf-8") as open_result_file:
        for info in result:
            open_result_file.write("%s %s\n" % (info[0], info[1]))
        open_result_file.flush()
    cursor.close()
    conn.close()
    if os.path.isfile(write_file):
        exec_flag = True
    return exec_flag


def main(argv):
    if argv[1] == "get_db_info":
        try:
            print(get_db_info(argv[2], argv[3], argv[4]))
        except Exception as e:
            LOGGER.error("[get_db_info] Exception: %s." % str(e))
            return 1
        return 0
    return 1


if __name__ == '__main__':
    main(sys.argv)
